% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_range_analysis.R
\name{diversity_range_analysis}
\alias{diversity_range_analysis}
\title{range_diversity_analysis: diversity analysis}
\usage{
diversity_range_analysis(
  pam,
  xy_mat = NULL,
  lower_interval = 0.05,
  upper_interval = 0.95,
  raster_templete = NULL,
  niter = 100,
  return_null_dfield = FALSE,
  randal = "fastball",
  parallel = TRUE,
  n_cores = 2
)
}
\arguments{
\item{pam}{A Presence-Absence-Matrix of matrix class or sparse matrix.}

\item{xy_mat}{A two dimensional matrix with longitude and latitude data.}

\item{lower_interval}{Lower interval.}

\item{upper_interval}{Upper interval.}

\item{raster_templete}{A raster template.}

\item{niter}{Number of iterations to obtain the distribution.}

\item{return_null_dfield}{If TRUE the null distribution of dispersal field
will be returned.}

\item{randal}{Randomization algorithm applied to the PAM.
Possible choices "curveball","fastball" and "indep_swap".}

\item{parallel}{If TRUE the computations will be performed in parallel.}

\item{n_cores}{Number of cores for the parallel computation.}
}
\value{
An object of class  \code{\link[bamm]{diversity_range}}. The main
result is the diversity range analysis which shows jointly two indices
describing the community composition of every cell in the grid:
(1) the relative number of species, and (2) the mean dispersion field
(see plot method for \code{\link[bamm]{plot}} (Soberon et al. 2022).
The contains 12 slots with different measurements of biodiversity such
as alpha diversity (species richness in each site or pixel),
omega (size of the area of distribution of each species),
dispersion field (the standardized size of the area of distribution of
all species occurring in each pixel).
}
\description{
diversity_range_analysis biodiversity indices related to
diversity-range plots
}
\details{
For more information about the biodiversity indices
see Soberon and Cavner (2015). For detail about the diversity range analysis
see Soberon et al. (2022). To plot diversity range results use
\code{\link[bamm]{plot}} method for objects of class
\code{\link[bamm]{diversity_range}}.

For details about randomization algorithms applied to the PAM see
\code{\link[bamm]{null_dispersion_field_distribution}}.
}
\examples{
set.seed(111)
pam <- matrix(rbinom(10000,1,0.5),nrow = 100,ncol = 1000)
rdivan <- bamm::diversity_range_analysis(pam=pam,
                                         parallel = FALSE,
                                         niter = 10,
                                         return_null_dfield=TRUE)
bamm::plot(rdivan,plot_type="diversity_range")
# Lagomorphos
\donttest{
lagos_path <- system.file("extdata/conejos",
                          package = "bamm")
enm_path <- list.files(lagos_path,
                       pattern = ".tif",
                       full.names = TRUE)
en_models <- raster::stack(enm_path) >0.01
nonas <- which(!is.na(en_models[[1]][]))
xy_mat <- sp::coordinates(en_models[[1]])[ nonas,]
pam <- bamm::models2pam(en_models,sparse=FALSE)

rdivan <- bamm::diversity_range_analysis(pam=pam,
                                         xy_mat=xy_mat,
                                         raster_templete = en_models[[1]],
                                         parallel=TRUE,
                                         n_cores=2,
                                         return_null_dfield=TRUE)
bamm::plot(rdivan,plot_type="diversity_range")
bamm::plot(rdivan,plot_type="diversity_range_map")
if(require(plotly) && require(crosstalk)){
#bamm::plot(rdivan,plot_type="diversity_range_interactive")
}
}
}
\references{
\insertRef{Soberon2022}{bamm}.

\insertRef{Soberon2015}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
