% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.quadrilateral}
\alias{sparsify.with.quadrilateral}
\title{Extract Nocaj et al.'s (2015) Quadrilateral Simmelian backbone}
\usage{
sparsify.with.quadrilateral(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \link[Matrix]{Matrix}; (2) an edgelist in the form of a two-column dataframe; (3) an \link[igraph]{igraph} object.}

\item{s}{numeric: Sparsification exponent, 0 < s < 1; larger values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "Matrix", "igraph", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.quadrilateral} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the quadrilateral Simmelian backbone described by Nocaj et al. (2015).
It is equivalent to \code{sparsify(escore = "quadrilateral embeddedness", normalize = "embeddedness", filter = "threshold", umst = TRUE)}.
}
\examples{
U <- igraph::sample_sbm(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.quadrilateral(U, s = 0.5, narrative = TRUE)
plot(sparse) #Clearly visible communities in a connected graph
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

model: {Nocaj, A., Ortmann, M., & Brandes, U. (2015). Untangling the hairballs of multi-centered, small-world online social media networks. \emph{Journal of Graph Algorithms and Applications, 19}, 595-618. \doi{10.7155/jgaa.00370}}
}
