% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.extract.R
\name{backbone.extract}
\alias{backbone.extract}
\title{Extracts a backbone network from a backbone object}
\usage{
backbone.extract(
  bb.object,
  signed = FALSE,
  alpha = 0.05,
  mtc = "none",
  class = bb.object$class,
  narrative = FALSE
)
}
\arguments{
\item{bb.object}{backbone: backbone S3 class object.}

\item{signed}{boolean: TRUE for a signed backbone, FALSE for a binary backbone (see details)}

\item{alpha}{real: significance level of hypothesis test(s)}

\item{mtc}{string: type of Multiple Test Correction to be applied; can be any method allowed by \code{\link{p.adjust}}.}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "sparseMatrix", "igraph", "edgelist"), converted via \link{tomatrix}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
backbone graph: Binary or signed backbone graph of class given in parameter \code{class}.
}
\description{
\code{backbone.extract} returns a binary or signed adjacency matrix
containing the backbone that retains only the significant edges.
}
\details{
The "backbone" S3 class object is composed of (1) the weighted graph as a matrix, (2) upper-tail p-values as a
matrix, (3, if \code{signed = TRUE}) lower-tail p-values as a matrix, (4, if present) node attributes as a dataframe, and
(5) several properties of the original graph and backbone model

When \code{signed = FALSE}, a one-tailed test (is the weight stronger?) is performed for each edge. The resulting backbone
contains edges whose weights are significantly \emph{stronger} than expected in the null model. When \code{signed = TRUE}, a
two-tailed test (is the weight stronger or weaker?) is performed for each edge. The resulting backbone contains
positive edges for those whose weights are significantly \emph{stronger}, and negative edges for those whose weights are
significantly \emph{weaker}, than expected in the null model.
}
\examples{
#A binary bipartite network of 30 agents & 75 artifacts; agents form three communities
B <- rbind(cbind(matrix(rbinom(250,1,.8),10),
                 matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.2),10)),
           cbind(matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.8),10),
                 matrix(rbinom(250,1,.2),10)),
           cbind(matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.2),10),
                 matrix(rbinom(250,1,.8),10)))

backbone.object <- fixedrow(B, alpha = NULL)
bb <- backbone.extract(backbone.object, alpha = 0.05)
}
