% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-client.R
\name{api_client}
\alias{api_client}
\title{Azure API Client}
\description{
An R6 class that provides a base HTTP client for interacting with Azure APIs.
This client handles authentication, request building, retry logic, logging,
and error handling for Azure API requests.
}
\details{
The \code{api_client} class is designed to be a base class for Azure service-specific
clients. It provides:
\itemize{
\item Automatic authentication using Azure credentials
\item Configurable retry logic with exponential backoff
\item Request and response logging
\item JSON, XML, and HTML content type handling
\item Standardized error handling
}
}
\examples{
\dontrun{
# Create a client with default credentials
client <- api_client$new(
  host_url = "https://management.azure.com"
)

# Create a client with a credential provider
cred_provider <- get_credential_provider(
  scope = "https://management.azure.com/.default"
)
client <- api_client$new(
  host_url = "https://management.azure.com",
  provider = cred_provider
)

# Create a client with custom credentials function
client <- api_client$new(
  host_url = "https://management.azure.com",
  credentials = my_credential_function,
  timeout = 120,
  max_tries = 3
)

# Create a client with custom response handler
custom_handler <- function(content) {
  # Custom processing logic - e.g., keep data frames as-is
  content
}
client <- api_client$new(
  host_url = "https://management.azure.com",
  response_handler = custom_handler
)

# Make a GET request
response <- client$.fetch(
  path = "/subscriptions/{subscription_id}/resourceGroups",
  subscription_id = "my-subscription-id",
  req_method = "get"
)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.host_url}}{Base URL for the API}

\item{\code{.base_req}}{Base httr2 request object}

\item{\code{.provider}}{Credential provider R6 object}

\item{\code{.credentials}}{Credentials function for authentication}

\item{\code{.options}}{Request options (timeout, connecttimeout, max_tries)}

\item{\code{.response_handler}}{Optional callback function to process response content}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-api_client-new}{\code{api_client$new()}}
\item \href{#method-api_client-.fetch}{\code{api_client$.fetch()}}
\item \href{#method-api_client-.req_build}{\code{api_client$.req_build()}}
\item \href{#method-api_client-.req_perform}{\code{api_client$.req_perform()}}
\item \href{#method-api_client-.resp_content}{\code{api_client$.resp_content()}}
\item \href{#method-api_client-.get_token}{\code{api_client$.get_token()}}
\item \href{#method-api_client-clone}{\code{api_client$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-new}{}}}
\subsection{Method \code{new()}}{
Create a new API client instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$new(
  host_url,
  provider = NULL,
  credentials = NULL,
  timeout = 60L,
  connecttimeout = 30L,
  max_tries = 5L,
  response_handler = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host_url}}{A character string specifying the base URL for the API
(e.g., \code{"https://management.azure.com"}).}

\item{\code{provider}}{An R6 credential provider object that inherits from the
\code{Credential} or \code{DefaultCredential} class. If provided, the credential's
\code{req_auth} method will be used for authentication. Takes precedence over
\code{credentials}.}

\item{\code{credentials}}{A function that adds authentication to requests. If
both \code{provider} and \code{credentials} are \code{NULL}, uses \code{\link[=default_non_auth]{default_non_auth()}}.
The function should accept an httr2 request object and return a modified
request with authentication.}

\item{\code{timeout}}{An integer specifying the request timeout in seconds.
Defaults to \code{60}.}

\item{\code{connecttimeout}}{An integer specifying the connection timeout in
seconds. Defaults to \code{30}.}

\item{\code{max_tries}}{An integer specifying the maximum number of retry
attempts for failed requests. Defaults to \code{5}.}

\item{\code{response_handler}}{An optional function to process the parsed response
content. The function should accept one argument (the parsed response) and
return the processed content. If \code{NULL}, uses \code{\link[=default_response_handler]{default_response_handler()}}
which converts data frames to data.table objects. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{api_client} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-.fetch"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-.fetch}{}}}
\subsection{Method \code{.fetch()}}{
Make an HTTP request to the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$.fetch(
  path,
  ...,
  req_data = NULL,
  req_method = "get",
  verbosity = 0L,
  content = c("body", "headers", "response", "request"),
  content_type = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A character string specifying the API endpoint path. Supports
\code{\link[glue:glue]{glue::glue()}} syntax for variable interpolation using named arguments
passed via \code{...}.}

\item{\code{...}}{Named arguments used for path interpolation with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{req_data}}{Request data. For GET requests, this is used as query
parameters. For other methods, this is sent as JSON in the request body.
Can be a list or character string (JSON).}

\item{\code{req_method}}{A character string specifying the HTTP method. One of
\code{"get"}, \code{"post"}, \code{"put"}, \code{"patch"}, or \code{"delete"}. Defaults to \code{"get"}.}

\item{\code{verbosity}}{An integer specifying the verbosity level for request
debugging (passed to \code{\link[httr2:req_perform]{httr2::req_perform()}}). Defaults to \code{0}.}

\item{\code{content}}{A character string specifying what to return. One of:
\itemize{
\item \code{"body"} (default): Return the parsed response body
\item \code{"headers"}: Return response headers
\item \code{"response"}: Return the full httr2 response object
\item \code{"request"}: Return the prepared request object without executing it
}}

\item{\code{content_type}}{A character string specifying how to parse the response
body. If \code{NULL}, uses the response's Content-Type header. Common values:
\code{"application/json"}, \code{"application/xml"}, \code{"text/html"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Depends on the \code{content} parameter:
\itemize{
\item \code{"body"}: Parsed response body (list, data.frame, or character)
\item \code{"headers"}: List of response headers
\item \code{"response"}: Full \code{\link[httr2:response]{httr2::response()}} object
\item \code{"request"}: \code{\link[httr2:request]{httr2::request()}} object
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-.req_build"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-.req_build}{}}}
\subsection{Method \code{.req_build()}}{
Build an HTTP request object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$.req_build(path, ..., req_data = NULL, req_method = "get")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A character string specifying the API endpoint path. Supports
\code{\link[glue:glue]{glue::glue()}} syntax for variable interpolation using named arguments
passed via \code{...}.}

\item{\code{...}}{Named arguments used for path interpolation with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{req_data}}{Request data. For GET requests, this is used as query
parameters. For other methods, this is sent as JSON in the request body.
Can be a list or character string (JSON).}

\item{\code{req_method}}{A character string specifying the HTTP method. One of
\code{"get"}, \code{"post"}, \code{"put"}, \code{"patch"}, or \code{"delete"}. Defaults to \code{"get"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[httr2:request]{httr2::request()}} object ready for execution
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-.req_perform"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-.req_perform}{}}}
\subsection{Method \code{.req_perform()}}{
Perform an HTTP request and log the results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$.req_perform(req, verbosity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object to execute}

\item{\code{verbosity}}{An integer specifying the verbosity level for request
debugging (passed to \code{\link[httr2:req_perform]{httr2::req_perform()}}). Defaults to \code{0}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[httr2:response]{httr2::response()}} object containing the API response
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-.resp_content"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-.resp_content}{}}}
\subsection{Method \code{.resp_content()}}{
Extract and parse response content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$.resp_content(resp, content_type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resp}}{An \code{\link[httr2:response]{httr2::response()}} object}

\item{\code{content_type}}{A character string specifying how to parse the response
body. If \code{NULL}, uses the response's Content-Type header. Common values:
\code{"application/json"}, \code{"application/xml"}, \code{"text/html"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Parsed response body. Format depends on content type:
\itemize{
\item JSON: List or data.frame
\item XML: xml2 document
\item HTML: xml2 document
\item Other: Character string
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-.get_token"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-.get_token}{}}}
\subsection{Method \code{.get_token()}}{
Get authentication token from the credential provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$.get_token()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object if a provider is available,
otherwise returns \code{NULL} with a warning.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_client-clone"></a>}}
\if{latex}{\out{\hypertarget{method-api_client-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
