% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoder.R
\name{decoder_model}
\alias{decoder_model}
\title{Builds the decoder graph for an AutoTab VAE}
\usage{
decoder_model(
  decoder_input,
  decoder_info,
  latent_dim,
  feat_dist,
  lip_dec,
  pi_dec,
  max_std = 10,
  min_val = 0.001,
  temperature = 0.5
)
}
\arguments{
\item{decoder_input}{Ignored; pass \code{NULL}. No input is needed when building the compitational graph.}

\item{decoder_info}{List defining the decoder architecture, e.g.
\code{list(list("dense", 80, "relu"), list("dropout", 0.1), list("dense", 100, "relu"))}.
Each \code{dense} entry is \code{list("dense", units, activation)}. Each \code{dropout}
entry is \code{list("dropout", rate)}. Optional elements:
\verb{[[4]]} L2 flag (0/1), \verb{[[5]]} L2 value, \verb{[[6]]} BN flag (FALSE/TRUE),
\verb{[[7]]} BN momentum, \verb{[[8]]} BN scale/center (TRUE/FALSE).}

\item{latent_dim}{Integer. Latent dimension used during training.}

\item{feat_dist}{Data frame with columns \code{column_name}, \code{distribution}, \code{num_params}
(created by \code{extracting_distribution()} and set via \code{set_feat_dist()}).}

\item{lip_dec}{0/1 (logical). Use spectral normalization on dense hidden layers.}

\item{pi_dec}{Integer. Power-iteration count for spectral normalization.}

\item{max_std}{Numeric. Upper bound for Gaussian SD heads (default \code{10.0}).}

\item{min_val}{Numeric. Lower bound (epsilon) for Gaussian SD heads (default \code{1e-3}).}

\item{temperature}{Numeric. Gumbel–Softmax temperature for categorical heads (default \code{0.5}).}
}
\value{
A compiled \strong{Keras model} representing the decoder computational graph. You can
load trained decoder weights with \code{Decoder_weights()} + \code{set_weights()}, then
call \code{predict(decoder, Z)} where \code{Z} is an \verb{n x latent_dim} matrix (typically a sample from your latent space).
}
\description{
Reconstructs the \strong{decoder} computational graph used during training. This is used
internally by \code{VAE_train()} and externally when you want to load the trained
decoder weights and generate new samples by sampling the latent space.
}
\details{
The final output layer of an AutoTab decoder slices outputs by feature distribution in \code{feat_dist}:
Gaussian heads output mean/SD (with \code{min_val}/\code{max_std} constraints),
Bernoulli heads output logits passed through sigmoid to extract probabilities,
and Categorical heads use Gumbel–Softmax with the given \code{temperature}.

If \code{lip_dec = 1}, dense hidden layers are wrapped with
#' spectral normalization using \code{pi_dec} power iterations.
}
\examples{
\donttest{
if (reticulate::py_module_available("tensorflow") &&
    exists("training") &&
    exists("feat_dist")) {

  # Assume you already have feat_dist set via set_feat_dist(feat_dist)
  decoder_info <- list(
    list("dense", 80, "relu"),
    list("dense", 100, "relu")
  )

  # Rebuild and apply decoder
  weights_decoder <- Decoder_weights(
    encoder_layers = 2,
    trained_model  = training$trained_model,
    lip_enc        = 0,
    pi_enc         = 0,
    prior_learn    = "fixed",
    BNenc_layers   = 0,
    learn_BN       = 0
  )

  decoder <- decoder_model(
    decoder_input = NULL,
    decoder_info  = decoder_info,
    latent_dim    = 5,
    feat_dist     = feat_dist,
    lip_dec       = 0,
    pi_dec        = 0
  )

  decoder \%>\% keras::set_weights(weights_decoder)
}
}

}
\seealso{
\code{\link[=VAE_train]{VAE_train()}}, \code{\link[=Decoder_weights]{Decoder_weights()}}, \code{\link[=encoder_latent]{encoder_latent()}}, \code{\link[=Latent_sample]{Latent_sample()}}, \code{\link[=extracting_distribution]{extracting_distribution()}}
}
