% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_items}
\alias{am_items}
\title{Get full item details from an object}
\usage{
am_items(doc, obj, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID, or \code{AM_ROOT} for the document root}

\item{heads}{Optional list of change hashes (raw vectors) for historical
query. If \code{NULL} (default), uses the current state.}
}
\value{
A list of lists, where each inner list has fields:
\describe{
\item{key}{For maps: the character key. For lists: the 1-based integer index.}
\item{value}{The value at this entry.}
}
}
\description{
Returns detailed information about each entry in a map or list, including
the key (or index) and value for each item. This provides more information
than \code{\link[=am_values]{am_values()}} alone.
}
\note{
When called on a text object, this iterates individual characters as
list items. Use \code{\link[=am_text_content]{am_text_content()}} to retrieve text as a string instead.
}
\examples{
doc <- am_create()
doc$name <- "Alice"
doc$age <- 30L

items <- am_items(doc, AM_ROOT)
items[[1]]$key    # "age" (sorted lexicographically)
items[[1]]$value  # 30

am_close(doc)

}
