% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_get_heads}
\alias{am_get_heads}
\title{Get the current heads of a document}
\usage{
am_get_heads(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A list of raw vectors, each containing a change hash. Usually there
is only one head, but after concurrent edits there may be multiple heads
until they are merged by a subsequent commit.
}
\description{
Returns the current "heads" of the document - the hashes of the most recent
changes. These identify the current state of the document and can be used
for history operations.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_commit(doc)

heads <- am_get_heads(doc)
cat("Document has", length(heads), "head(s)\n")

am_close(doc)

}
