% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_from_bytes}
\alias{am_cursor_from_bytes}
\title{Restore a cursor from bytes}
\usage{
am_cursor_from_bytes(bytes, obj)
}
\arguments{
\item{bytes}{A raw vector containing a serialized cursor}

\item{obj}{An Automerge text object to associate the cursor with}
}
\value{
An \code{am_cursor} object
}
\description{
Restores a cursor from a raw vector previously created by
\code{\link[=am_cursor_to_bytes]{am_cursor_to_bytes()}}. The text object is required to associate the
cursor with a document.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

cursor <- am_cursor(text_obj, 5)
bytes <- am_cursor_to_bytes(cursor)

restored <- am_cursor_from_bytes(bytes, text_obj)
restored
am_cursor_position(restored)  # 5

am_close(doc)

}
\seealso{
\code{\link[=am_cursor_to_bytes]{am_cursor_to_bytes()}}
}
