% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_message}
\alias{am_change_message}
\title{Get the commit message of a change}
\usage{
am_change_message(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}},
\code{\link[=am_get_changes]{am_get_changes()}}, or \code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A character string containing the commit message, or \code{NULL}
}
\description{
Returns the commit message attached to a change, or \code{NULL} if no message
was provided when the change was committed.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key")

history <- am_get_changes(doc)
am_change_message(history[[1]])  # "Add key"

am_close(doc)

}
