% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzDistinctnessCodeToOffset}
\alias{hzDistinctnessCodeToOffset}
\title{Convert Horizon Boundary Distinctness to Vertical Offset}
\usage{
hzDistinctnessCodeToOffset(
  x,
  codes = c("very abrupt", "abrupt", "clear", "gradual", "diffuse"),
  offset = c(0.5, 2, 5, 15, 20)/2
)
}
\arguments{
\item{x}{vector of boundary distinctness codes to be converted}

\item{codes}{character vector of distinctness terms ('clear') or codes ('C'), case insensitive, see details}

\item{offset}{vertical offset factors (cm), approximating 1/2 of the transitional zone thickness, see details}
}
\value{
vector of offsets with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary distinctness codes into vertical (+/-) offsets in cm, based on the \href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\details{
The default offsets are based on the high-end of ranges presented in "transitional zone thickness criteria" from the Field Book version 3.0 (page 2-6). Offsets are returned as 1/2 of the transitional zone thickness so that horizon boundaries can be adjusted up/down from horizon depths. See \code{\link{plotSPC}}, specifically the \code{hz.distinctness.offset} argument for visualization ideas. Missing data in \code{x} (NA) or codes that are not defined in \code{codes} are returned as 0 offsets.

Either format (or mixture) are accepted, case insensitive:
\itemize{
\item terms: \code{c('very abrupt', 'abrupt', 'clear', 'gradual', 'diffuse')}
\item coded values: \verb{c('v', 'a', 'c', 'g', d')}
}

Additional examples are available in the \href{https://ncss-tech.github.io/AQP/aqp/hz-boundaries.html}{Visualization of Horizon Boundaries tutorial}.
}
\examples{
# example data
data(sp1)

# compute 1/2 transitional zone thickness from distinctness codes
sp1$hzdo <- hzDistinctnessCodeToOffset(sp1$bound_distinct)

# convert colors from Munsell to hex-encoded RGB
sp1$soil_color <- with(sp1, munsell2rgb(hue, value, chroma))

# promote to SoilProfileCollection
depths(sp1) <- id ~ top + bottom
hzdesgnname(sp1) <- 'name'

# adjust margins
op <- par(mar=c(0,0,0,1.5))

# sketches, adjust width, adjust text size, include coded hz distinctness offsets
plotSPC(sp1, width=0.3, cex.names=0.75, hz.distinctness.offset = 'hzdo')

# clean-up
par(op)
}
\references{
\href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
