% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_checkArguments.R
\name{apollo_checkArguments}
\alias{apollo_checkArguments}
\title{Checks definitions of Apollo functions}
\usage{
apollo_checkArguments(
  apollo_probabilities = NA,
  apollo_randCoeff = NA,
  apollo_lcPars = NA
)
}
\arguments{
\item{apollo_probabilities}{Function. Likelihood function as defined by the user.}

\item{apollo_randCoeff}{Function. Used with mixing models. Constructs the random parameters of a mixing model. Receives two arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters. 
  \item \strong{\code{apollo_inputs}}: The output of this function (\code{apollo_validateInputs}).
}}

\item{apollo_lcPars}{Function. Used with latent class models. Constructs a list of parameters for each latent class. Receives two arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters. 
  \item \strong{\code{apollo_inputs}}: The output of this function (\code{apollo_validateInputs}).
}}
}
\value{
Returns (invisibly) TRUE if definitions are correct, and FALSE otherwise.
}
\description{
Checks that the user-defined functions used by Apollo are correctly defined by the user.
}
\details{
It only checks that the functions have the correct definition of inputs. It does not run the functions.
}
