% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/intervals.R
\docType{methods}
\name{intervals}
\alias{intervals}
\alias{intervals-method}
\alias{intervals,RataDie,RataDie,missing-method}
\alias{intervals,numeric,numeric,TimeScale-method}
\title{Create Time Intervals}
\usage{
intervals(start, end, calendar, ...)

\S4method{intervals}{RataDie,RataDie,missing}(start, end, names = NULL)

\S4method{intervals}{numeric,numeric,TimeScale}(start, end, calendar, scale = 1, names = NULL)
}
\arguments{
\item{start}{A \code{\link{numeric}} vector of (decimal) years or a \code{\linkS4class{RataDie}}
object (see \code{\link[=fixed]{fixed()}}) giving the beginning of the time intervals.}

\item{end}{A \code{\link{numeric}} vector of (decimal) years or a \code{\linkS4class{RataDie}}
object (see \code{\link[=fixed]{fixed()}}) giving the end of the time intervals.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the calendar of
\code{time} (see \code{\link[=calendar]{calendar()}}). If missing, \code{time} must be a \code{\linkS4class{RataDie}}
object.}

\item{...}{Currently not used.}

\item{names}{A \code{\link{character}} string specifying the names of the time
series.}

\item{scale}{A length-one \code{\link{numeric}} vector specifying the number of years
represented by one unit. It should be a power of 10 (i.e. 1000 means ka).}
}
\value{
A \code{\linkS4class{TimeIntervals}} object.
}
\description{
An Interval is elapsed time in seconds between two specific years.
}
\examples{
## Create time intervals
int <- intervals(
  start = c(625, 700, 1200, 1225, 1250, 500, 1000, 1200,
            1325, 1375, 1200, 1300, 1375, 1275, 1325),
  end = c(750, 825, 1250, 1275, 1325, 700, 1300, 1325,
          1400, 1500, 1300, 1375, 1500, 1325, 1425),
  calendar = CE()
)

## Plot intervals
plot(int) # Default calendar

## Overlap
overlap(int, calendar = CE())
}
\author{
N. Frerebeau
}
\concept{time intervals}
