\name{AbPval}
\alias{AbPval}

\title{Determination of the percentile of r and r-squared, by correlation.  Here designated "Abernethy's P-value"}

\description{
The percentile of r and r-squared (prr) generated by pivotal Monte Carlo analysis has been promoted as a goodness of fit measure by Robert B. Abernethy. 
}

\usage{
AbPval(F,R2,model="weibull")
}

\arguments{
  \item{F}{The quantity of complete failure data points under consideration.}
  \item{R2}{The square of the correlation coefficient derived from residuals of the linear model.}
  \item{model}{A string defining the distribution under consideration. Only entry of "lnorm", or "lognormal" will alter the default of "weibull".}
}

\details{The value returned is derived from a correlation developed from previously run pivotal analysis with 10^8 random samples.  Only the prr derived from 2 parameter models is judged to have usefullness in comparitive analysis. For validity of a 3rd parameter optimization on a given model over its 2 parameter fit, only the Likelihood Ratio Test should be considered.  
}

\value{
Returns a vector containing the  P-value and the square of CCC (for comparison with R squared).
}

\references{
  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition"
  
  Wes Fulton, (2005) "Improved Goodness of Fit: P-value of the Correlation Coefficient"
%                            \url{http://www.barringer1.com/jun05prb.htm}

  Chi-Chao Lui, (1997) "A Comparison Between The Weibull And Lognormal Models Used To Analyse Reliability Data"
  (dissertation from University of Nottingham)
}

\examples{
AbernethyPvalue<-AbPval(50, 0.996, "lnorm")
}

\keyword{ regression reliability goodness-of-fit}