% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{random_stream}
\alias{random_stream}
\title{Creates an environment (similar to R6 class) of random uniform numbers to be drawn from}
\usage{
random_stream(stream_size = 100)
}
\arguments{
\item{stream_size}{Length of the vector of random uniform values to initialize}
}
\value{
Self (environment) behaving similar to R6 class
}
\description{
Creates an environment (similar to R6 class) of random uniform numbers to be drawn from
}
\details{
This function creates an environment object that behaves similar to an R6 class
but offers more speed vs. an R6 class.

The object is always initialized (see example below) to a specific vector of
random uniform values. The user can then call the object with \code{obj$draw_number(n)},
where n is an integer, and will return the first n elements of the created
vector of uniform values. It will automatically remove those indexes from the
vector, so the next time the user calls \code{obj$draw_n()} it will already consider
the next index.

The user can also access the latest elements drawn by accessing \code{obj$random_n}
(useful for when performing a luck adjustment), the current stream still
to be drawn using \code{obj$stream} and the original size (when created) using
\code{obj$stream_size}.

If performing luck adjustment, the user can always modify the random value
by using \code{obj$random_n <- luck_adj(...)} (only valid if used with the expression
approach, not with \code{modify_item})
}
\examples{
stream_1 <- random_stream(1000)
number_1 <- stream_1$draw_n() #extract 1st index from the vector created
identical(number_1,stream_1$random_n) #same value
number_2 <- stream_1$draw_n() #gets 1st index (considers previous)
identical(number_2,stream_1$random_n) #same value
}
