% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tabla.R
\name{Tabla}
\alias{Tabla}
\title{Cree fácilmente un widget para visualización de tablas HTML usando el paquete \code{DT}}
\usage{
Tabla(
  datos,
  df,
  rows,
  pivotCat,
  pivotVar,
  columnNames,
  filtros = FALSE,
  colFilters,
  estadistico = c("Suma", "Promedio", "Mediana", "Varianza", "SD", "CV", "Min", "Max"),
  encabezado = "Encabezados de los Niveles de la Categoría",
  leyenda = "",
  tituloPdf = NULL,
  mensajePdf = "",
  ajustarNiveles = TRUE,
  scrollX = TRUE,
  fillContainer = NULL,
  colorHead = "#FFFFFF",
  estilo,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame.}

\item{df}{Argument deprecated, use \code{datos} instead.}

\item{rows}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{pivotCat}{Variable categórica que contiene los niveles/factores que desea
pivotear como columnas. Si omite este parámetro se da por hecho que no desea
pivotear nada sino graficar tal cual su data frame}

\item{pivotVar}{Variable numérica que contiene los valores que desea colocar
en cada celda al realizar el pivotaje.}

\item{columnNames}{Vector de caracteres que especifica los nombres de las columnas
de la tabla a retornar. Si no se introduce algún valor se tomará el mismo
nombre de las columnas presentes en \code{datos}.}

\item{filtros}{Si es \code{FALSE} (\emph{valor predeterminado}) no se habilitará/aplicará
los filtros por columna. Establézcalo en \code{TRUE} si desea generar filtros de
columna automáticamente.}

\item{colFilters}{Vector numérico que especifica las columnas a las cuales les
desea agregar la opción de poder filtrar. Si no se introduce algún valor todas
las columnas tendrán habilitada la opción de poder filtrar.}

\item{estadistico}{X.}

\item{encabezado}{Cadena de caracteres que describe los distintos niveles de
la variable \code{categoria}.}

\item{leyenda}{Cadena de caracteres que describe información adicional de la
tabla, ésta se sitúa en la parte inferior de la tabla de manera centrada,
dicho texto se visualizará en todas las opciones de descarga. Su valor por
defecto es \code{NULL}.}

\item{tituloPdf}{Cadena de caracteres que proporciona un título a la tabla al
momento de generar el \code{.pdf} como al hacer clic al botón de imprimir. Su valor
por defecto es el introducido en el argumento \code{encabezado}.}

\item{mensajePdf}{Cadena de caracteres que proporciona un mensaje situado entre
el título y la tabla. Se visualizará tanto al generar el \code{.pdf} como al
hacer clic al botón de imprimir.}

\item{ajustarNiveles}{Si es \code{TRUE} (\emph{valor predeterminado}) se buscará optimizar
el espacio entre las columnas, colocando todos los nombres de las columnas de
forma horizontal y eliminando al máximo el espacio entre éstas.}

\item{scrollX}{Si es \code{TRUE} (\emph{valor predeterminado}) se habilitará la propiedad
Scroller para el eje X. Tenga presente que cuando su df contiene muchas columnas
es de utilidad (\emph{pues no permite que se salga la tabla por ancho}), sin embargo,
asegúrese de desactivarlo cuando presente pocas columnas, pues se verá un
desplazamiento de los encabezados debido a un conflicto interno.}

\item{fillContainer}{Valor booleano para indicar si desea que la tabla rellene
automáticamente el elemento que lo contiene.}

\item{colorHead}{Cadena de caracteres que indica el color de fondo de la cabecera
de la tabla. Puede indicar el color con el nombre (\code{"red"}), código hexadecimal
(\code{"#FF0000"}) o RGB (\code{rgb(1, 0, 0)}). El valor por defecto es "blanco" (\code{"#FFFFFF"}).}

\item{estilo}{Una lista compuesta por listas las cuales en su interior contiene
argumentos válidos de la función \link[DT:formatCurrency]{formatStyle()}, esto
con la finalidad de que pueda aplicar estilos CSS a la tabla, tales como color
de la fuente, color de fondo, tamaño de fuente, etc. Puede encontrar mayor
información de los argumentos disponibles \href{https://rstudio.github.io/DT/functions.html}{aquí}.
\itemize{
\item \code{Tema}: Modifica el tema con el cual se creará la tabla Los posibles
valores son un número entero entre \eqn{[1, 14]} el cual hace referencia
a diferentes temas disponibles para \code{gt}/\code{gtExtras} (los primeros 6 se
obtienen con \code{opt_stylize(style = i, color = "gray")}, \code{gt_theme_538},
\code{gt_theme_dark}, \code{gt_theme_dot_matrix}, \code{gt_theme_espn}, \code{gt_theme_excel},
\code{gt_theme_guardian}, \code{gt_theme_nytimes} y \code{gt_theme_pff} respectivamente).
\item \code{Titulo}: Cadena de caracteres indicando el título principal de la tabla.
\item \code{Padding}: Vector numérico de longitud 2, que tiene como primera coordenada
el padding vertical, es decir si aumenta o disminuye el relleno vertical.
Y como segunda coordenada el padding horizontal.
\item \code{Color}: Lista compuesta de listas, en la cual cada una de ellas detalla,
qué columna se va a afectar y con qué colores de relleno, es decir,
\code{list(columns = Columna , backgroundColor = Colores)}.
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) la tabla a retornar será
dinámica (\emph{usando la librería} \code{DT}), en caso contrario se retornará una tabla
estática construida con \code{gt} y \code{gtExtras}.}
}
\value{
Retorna la tabla creada mediante \code{DT} la cual pertenece a la clase "datatables"
y "htmlwidget".
}
\description{
Esta función está diseñada para facilitar/simplificar la creación/producción de tablas para informes, presentaciones y
publicaciones, produciendo un widget HTML para visualizar un data frame
utilizando el paquete \code{DT}. La forma en que esta función maneja las cosas por
usted significa que a menudo no tiene que preocuparse por los pequeños detalles
para obtener un resultado impresionante y listo para usar.
}
\details{
Esta función se basa enteramente del paquete \code{DT}, el cual proporciona una
interfaz para \code{R} a la biblioteca \code{DataTables} de \code{JavaScript}. Los data frames
de \code{R} se pueden mostrar como tablas en páginas HTML, proporcionando opciones
de filtrado, paginación, clasificación y muchas otras características en las
tablas.

Esta función se basa enteramente del paquete \code{DT}, el cual proporciona una interfaz
para \code{R} a la biblioteca \code{DataTables} de \code{JavaScript}. Los data frames de \code{R}
se pueden mostrar como tablas en páginas HTML, proporcionando opciones de
filtrado, paginación, clasificación y muchas otras características en las tablas.

Al establecer \code{filtros = FALSE} no elimina ni modifica el filtro global
(\emph{cuadro de búsqueda en la parte superior derecha}).

Para el argumento \code{colFilters} recuerde que la numeración inicia en 0, es decir,
la primera columna tiene asociado el índice 0, la segunda el 1, y así sucesivamente.
}
\examples{
\dontshow{if (all(require("DT"), require("dplyr"), require("tidyr"))) withAutoprint(\{ # examplesIf}
# library(DT); library(dplyr); library(tidyr)
# Example of R Combinations with Dot (".") and Pipe (\%>\%) Operator
# UnalR::Agregar(
#   datos      = UnalData::Graduados,
#   formula    = SEDE_NOMBRE_ADM ~ YEAR + SEMESTRE,
#   frecuencia = list("Year" = 2009:2022, "Period" = 1:2)
#   ) |>
#   select(-Variable) |>
#   rename(Year = YEAR, Semester = SEMESTRE, Cat = Clase) \%>\%
#   Tabla(
#     ., rows = vars(Year, Semester), pivotCat = Cat, pivotVar = Total
#   )
Tabla(
  datos       = ejConsolidadoGrad |> dplyr::filter(Variable == "SEDE_NOMBRE_ADM") |>
    dplyr::select(-Variable),
  rows        = vars(YEAR, SEMESTRE),
  pivotCat    = Clase,
  pivotVar    = Total,
  columnNames = c("Año", "Semestre", "Total"),
  estadistico = "Suma",
  encabezado  = "TOTAL DE ESTUDIANTES \u00d7 SEDE DE GRADUACI\u00d3N",
  leyenda     = "Distribuci\u00f3n de estudiantes graduados (desde el 2009-I al 2021-I) por sede.",
  tituloPdf   = "ESTUDIANTES GRADUADOS POR SEDE",
  colorHead   = "#8CC63F",
  estilo      = list(
    list(
      columns = "YEAR", target = "cell", fontWeight = "normal",
      backgroundColor = styleEqual(
        unique(ejConsolidadoGrad$YEAR), rainbow(13, alpha = 0.5, rev = TRUE)
      )
    ),
    list(
      columns = "SEMESTRE", target = "cell", fontWeight = "bold",
      color = styleEqual(unique(ejConsolidadoGrad$SEMESTRE), c("#EB0095", "#9D45FD"))
    )
  )
)
# ---------------------------------------------------------------------------
VariosYears <- ejConsolidadoSaberPro2019         |>
  mutate(YEAR = replace(YEAR, YEAR==2019, 2020)) |>
  bind_rows(ejConsolidadoSaberPro2019)           |>
  filter(Variable == "sede") |> select(-Variable, -desv)

Msj <- "\u00c9sta es una descripci\u00f3n de la tabla diferente al valor por default."
Tabla(
  datos       = VariosYears,
  rows        = vars(YEAR, Clase, n),
  pivotCat    = Componente,
  pivotVar    = Total,
  columnNames = c("Año", "Sede", "n", "M\u00e1ximo"),
  estadistico = "Max",
  encabezado  = "PUNTAJES \u00d7 SEDE",
  leyenda     = Msj,
  colorHead   = "#F9CA00",
  estilo      = list(
    list(
      columns = "YEAR", target = "cell", fontWeight = "normal",
      backgroundColor = styleEqual(unique(VariosYears$YEAR), c("#AEF133", "#19EE9F"))
    ),
    list(
      columns = "Clase", target = "cell", fontWeight = "bold",
      color = styleEqual(unique(VariosYears$Clase), c("#42C501", "#7E10DE", "#FF6700", "#0096F2"))
    )
  )
)
# ---------------------------------------------------------------------------
Tabla(datos = datasets::mtcars)

df <- ejGraduados |>
  filter(TIPO_NIVEL == "Pregrado") |>
  group_by(YEAR, SEMESTRE, DEP_NAC, CIU_NAC, SEXO, CAT_EDAD, ESTRATO, PROGRAMA) |>
  summarise(Total = n(), .groups = "drop") |>
  mutate(across(where(is.character), \(x) replace_na(x, replace = "SIN INFO")))

Nombres <- c("<em>A\u00f1o</em>", "Semestre", "Departamento",
             "Municipio", "Sexo", "Edad", "Estrato", "Carrera", "Total"
             )
Titulo  <- paste(
  "<b>HIST\u00d3RICO DEL TOTAL DE GRADUADOS DE PREGRADO ",
  "DEPENDIENDO DE LAS VARIABLES SELECCIONADAS</b>"
)
Tabla(
  datos          = df,
  columnNames    = Nombres,
  filtros        = TRUE,
  colFilters     = 0:3,
  encabezado     = Titulo,
  leyenda        = "N\u00famero de graduados de pregrado por lugar de procedencia.",
  tituloPdf      = "Este es un t\u00edtulo provisional para el PDF",
  mensajePdf     = "Este es un mensaje provisional para el PDF",
  ajustarNiveles = TRUE,
  colorHead      = "#4CFF49",
  estilo         = list(
    list(
      columns = "YEAR", target = "cell", fontWeight = "bold",
      backgroundColor = styleEqual(unique(df$YEAR), c("#FF6400", "#01CDFE", "#FF0532"))
    ),
    list(
      columns = "SEMESTRE", target = "cell", fontWeight = "bold",
      color = styleEqual(unique(df$SEMESTRE), c("#3D3397", "#AE0421"))
    ),
    list(columns = "DEP_NAC", color = "#FFFFFF", backgroundColor = "#4D1B7B"),
    list(columns = "CIU_NAC", color = "#FFFFFF", backgroundColor = "#F59E11")
  )
)
\dontshow{\}) # examplesIf}
\dontshow{if (all(require("tibble"))) withAutoprint(\{ # examplesIf}
# library(tibble)
# ---------------------------------------------------------------------------
# Ejemplo Usando Directamente un Consolidado de Microdatos (Compose functions with Agregar)
set.seed(2023)
AcademyAwards <- tibble(
  year     = sample(1939:1945, 100, TRUE),
  season   = sample(1:2, 100, TRUE),
  category = sample(
    c("Best Picture", "Best Director", "Best Actor", "Best Actress", "Best Sound"),
    100, TRUE
  ),
  location = sample(c("Roosevelt Hotel", "Dolby Theatre", "NBC Century Theatre"), 100, TRUE)
)
Agregar(
  datos      = AcademyAwards,
  formula    = category + location ~ year + season,
  frecuencia = list("Year" = 1939:1945, "Period" = 1:2)
) \%>\%
  Tabla(., pivotCat = "location", columnNames = c("Year", "Season"),
        encabezado = "LOCATION OF CEREMONIES", scrollX = FALSE
  )
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE)) withAutoprint(\{ # examplesIf}
# library(gt); library(gtExtras)
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (gt)
tableGT <- Tabla(
  datos       = UnalR::ejConsolidadoGrad |> filter(Variable == "SEDE_NOMBRE_ADM"),
  rows        = vars(YEAR),
  pivotCat    = Clase,
  pivotVar    = Total,
  encabezado  = "TOTAL DE ESTUDIANTES \u00d7 SEDE DE GRADUACI\u00d3N",
  leyenda     = paste(
    "Distribuci\u00f3n de estudiantes graduados ",
    "(desde el 2009-I al 2021-I) por sede."
  ),
  colorHead   = "#8CC63F",
  estatico    = TRUE,
  estilo      = list(
    Tema = 11, Padding = c(0, 0.5), Titulo = "Summary Table:",
    Color = list(
      list(columns = "YEAR"     , backgroundColor = rainbow(12, alpha = 0.5, rev = TRUE)),
      list(columns = "Palmira"  , backgroundColor = "ggsci::red_material"),
      list(columns = "Manizales", backgroundColor = "viridis")
    )
  )
)
# ---------------------------------------------------------------------------
# Ejemplo usando algunos parámetros adicionales de personalización de gt/gtExtras
#   (para ver el alcance que puede tener)
tableGT <-
  Tabla(
    datos       = UnalR::ejConsolidadoGrad |> filter(Variable == "SEDE_NOMBRE_ADM"),
    rows        = vars(YEAR, SEMESTRE),
    pivotCat    = Clase,
    pivotVar    = Total,
    estadistico = "Suma",
    encabezado  = "TOTAL DE ESTUDIANTES \u00d7 SEDE DE GRADUACI\u00d3N",
    leyenda     = paste(
      "Distribuci\u00f3n de estudiantes graduados ",
      "(desde el 2009-I al 2021-I) por sede."
    ),
    colorHead   = "#AA0000",
    estatico    = TRUE,
    estilo      = list(
      Tema = 14, Padding = c(0, 0.5), Titulo = "SUMMARY TABLE",
      Color = list(
        list(columns = "YEAR"     , backgroundColor = rainbow(12, alpha = 0.5, rev = TRUE)),
        list(columns = "SEMESTRE" , backgroundColor = c("#EB0095", "#9D45FD"))
      )
    )
  )

Win <- "<span style=\"color:green\">&#128170;</span>"
Loss <- "<span style=\"color:red\">&#128165;</span>"
tableGT |>
  # __________________ INSERTANDO UN PIE DE PÁGINA ADICIONAL ___________________
  tab_source_note(source_note = "Source: Dirección Nacional de Planeación y Estadística (DNPE).") |>
  # ___________________ CREANDO UN GRUPO/COLECCIÓN DE FILAS ____________________
  tab_row_group(label = "< 2010"       , rows = 1:2)   |>
  tab_row_group(label = "[2010 - 2019]", rows = 3:22)  |>
  tab_row_group(label = ">= 2020"      , rows = 23:25) |>
  # __________ MODIFICANDO LA ALINEACIÓN DE CADA UNA DE LAS COLUMNAS ___________
  cols_align(align = "center", columns = Amazonía:Tumaco)  |>
  cols_align(align = "left"  , columns = where(is.factor)) |>
  # ___________________ COLOREANDO LAS CELDAS DE UNA COLUMNA ___________________
  data_color(
    columns = Statistic,
    method  = "bin",
    bins    = c(0, 3000, 4500, 10000),
    palette = c("#F44336", "#34AEC6", "#76CF44")
  ) |>
  # ___________ MODIFICANDO ASPECTOS GENERALES/GLOBALES DE LA TABLA ____________
  tab_options(
    heading.align = "right", heading.background.color = "#490948",
    table.font.size = px(12), heading.title.font.size = px(16)
  ) |>
  # ______________ CAMBIANDO EL FORMATO DE LOS VALORES NUMÉRICOS _______________
  fmt_currency(columns = c(Orinoquía:Palmira), currency = "USD") |>
  fmt_percent(columns = Tumaco, decimals = 1) |>
  # _ AÑADIENDO ALGUNOS DE LOS ESTILOS PERSONALIZADOS DISPONIBLES A LAS CELDAS _
  tab_style(
    style = cell_fill(color = "#C90076"), locations = cells_column_spanners()
  ) |>
  tab_style(
    style = list(cell_text(color = "#A5FD45", style = "italic")),
    locations = cells_body(columns = SEMESTRE, rows = SEMESTRE == "1")
  ) |>
  tab_style_body(
    style = cell_text(color = "#0CEAC0", weight = "bold"),
    columns = Amazonía,
    fn = function(x) between(x, 5, 20)
  ) |>
  text_transform(
    fn = function(x) paste(x, Win),
    locations = cells_body(columns = "Caribe", rows = Bogotá > 3*Medellín)
  ) |>
  text_transform(
    fn = function(x) paste(x, Loss),
    locations = cells_body(columns = "Caribe", rows = Bogotá <  3*Medellín)
  ) |>
  # __________________________ MODIFICANDO LA FUENTE ___________________________
  opt_table_font(
    # font = google_font(name = "Merriweather"),
    stack = "rounded-sans",
    weight = "bolder"
  ) |>
  # ____________ OPCIONES ADICIONALES CON LIBRERÍAS COMPLEMENTARIAS ____________
  gtExtras::gt_highlight_rows(rows = 18, fill = "#FEEF05", font_weight = "bold") |>
  gtExtras::gt_add_divider(Bogotá, color = "#F94D00", style = "dotted", weight = px(4)) |>
  gtExtras::gt_plt_bar_pct(Medellín, fill = "#2A8A9C", background = "#0DC8A7", scaled = FALSE)

# Use el siguiente comando si desea guardar la tabla estática obtenida:
# gtsave(tableGT, "TablaResumen.html") # O .tex, docx
\dontshow{\}) # examplesIf}
}
