% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaticPlot.R
\name{StaticPlot}
\alias{StaticPlot}
\title{Guarde y presente un widget HTML renderizado como una imagen estática}
\usage{
StaticPlot(widgetHTML, height = 500, primeraVez = FALSE, ...)
}
\arguments{
\item{widgetHTML}{Widget \code{HTML} a ser mostrado de forma estática.}

\item{height}{Altura de la imagen estática a retornar.}

\item{primeraVez}{Si es \code{FALSE} (\emph{valor predeterminado}) no se instalará \code{PhantomJS}.
Éste es necesario instalarlo una única vez, por lo cual si es la primera vez
que corre la función deberá indicar el argumento con el valor \code{TRUE}, después
de esto omita este argumento y deje su valor por defecto.}

\item{...}{Otros parámetros concernientes a la función \link[webshot:webshot]{webshot()},
sin considerar los ya usados dentro de la función (\code{url}, \code{file}, \code{delay}, \code{zoom} y \code{vheight}).}
}
\value{
Una imagen estática.
}
\description{
Esta función permite representar un widget HTML como un objeto ráster
(\emph{imagen de mapa de bits}), útil para reproducir gráficos interactivos en
archivos estáticos como un \code{.pdf} generado por \verb{R Markdown}. Esta función usa
internamente los paquetes \code{webshot}, \code{htmlwidgets}, \code{png} y \code{grid} para poder
llevar a cabo su propósito.
}
\details{
No es necesario especificar el número del factor de zoom. El factor de zoom por
defecto es 5, el cual dará como resultado cinco veces más de píxeles vertical
y horizontalmente. Este valor fue seleccionado debido a que es el óptimo, un
valor mayor ocasiona un tiempo de ejecución excesivamente alto y poca ganancia
en cuanto a calidad, con un valor menor se tiene una pérdida considerable de
calidad.

Si se especifican tanto el ancho como el alto, es probable que la imagen se
distorsione. Por lo tanto, el único argumento variable será la altura de la
imagen, dejando el ancho como un argumento adaptativo dependiendo del ancho
disponible.

El tiempo de espera antes de tomar una captura de pantalla, en segundos, es de
\eqn{1s}. Este valor es debido a que se necesita un retraso mayor para que los
gráficos generados por \code{Highcharter} se muestren correctamente.
}
\examples{
\dontshow{if (all(FALSE)) withAutoprint(\{ # examplesIf}
misColores <- c(
  "#29ABE2", # AZUL CLARO  | Amazonia
  "#8CC63F", # VERDE       | Bogota
  "#CC241D", # ROJO        | Caribe
  "#0071BC", # AZUL VIVO   | Manizales
  "#F15A24", # NARANJA     | Medellin
  "#FBB03B", # AMARILLO    | Orinoquia
  "#93278F", # MORADO      | Palmira
  "#8A381A"  # GRIS        | Tumaco
)
figure <- Plot.Series(
  datos     = ejConsolidadoGrad,
  categoria = "SEDE_NOMBRE_ADM",
  colores   = misColores,
  libreria  = "highcharter"
)
StaticPlot(figure, primeraVez = TRUE)

figure2 <- Plot.Torta(
  datos     = ejConsolidadoGrad,
  categoria = "SEXO",
  ano       = 2021,
  periodo   = 1,
  colores   = c("#116BEE", "#E62272"),
  titulo    = "DISTRIBUCI\u00d3N DE GRADUADOS POR SEXO",
  libreria  = "highcharter"
)
StaticPlot(figure2)
\dontshow{\}) # examplesIf}
}
