% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{EncProb}
\alias{EncProb}
\title{Encounter probabilities}
\usage{
EncProb(n, yrs, RP, dist = "Poisson")
}
\arguments{
\item{n}{number of events}

\item{yrs}{number of years}

\item{RP}{return period of the events}

\item{dist}{choice of probability distribution. Either "Poisson" or "Binomial"}
}
\value{
A probability
}
\description{
Calculates the probability of experiencing at least n events with a given return period (RP), over a given number of years
}
\details{
The choice of binomial or Poisson distributions for calculating encounter probablities is akin to annual maximum (AM) versus peaks over threshold (POT) approaches to extreme value analysis. AM and binomial assume only one "event" can occur in the blocked time period. Whereas Poisson and POT don't make this assumption. In the case of most catchments in the UK, it is rare to have less than two independent "events" per year; in which case the Poisson and POT choices are more suitable. In large catchments, with seasonally distinctive baseflow, there may only be one independent peak in the year. However, the results from both methods converge with increasing magnitude, yielding insignificant difference beyond a 20-year return period.
}
\examples{
# Calculate the probability of exceeding at least one 50-year RP event
# over a 10-year period, using the Poisson distribution
EncProb(n = 1, yrs = 10, RP = 50)

# Calculate the probability of exceeding at least two 100-year RP events
# over a 100-year period, using the Binomial distribution
EncProb(n = 2, yrs = 100, RP = 100, dist = "Binomial")

}
\author{
Anthony Hammond
}
