% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventNumber.R
\name{eventNumber}
\alias{eventNumber}
\title{Triggering condition by number of events or observations of an endpoint}
\usage{
eventNumber(endpoint, n, ..., arms = NULL)
}
\arguments{
\item{endpoint}{character. Name of an endpoint.}

\item{n}{integer. Targeted number of events.}

\item{...}{subset conditions compatible with \code{dplyr::filter}. Number
of events will be counted on subset of trial data only.}

\item{arms}{vector of character. Name of arms on which the number of events
is counted. If \code{NULL}, use all arms that are not yet removed from the
trial by the time of calculation.}
}
\value{
an object of class `Condition`
}
\description{
Define a condition to trigger trial milestone by the number of events of a
time-to-event endpoint or the number of non-missing observations of a
non-time-to-event endpoint. The milestone will be triggered when a trial has
observed at least the specified number of endpoint events (or non-missing
observations). It can be used combined with
conditions specified by \link[TrialSimulator]{calendarTime} and
\link[TrialSimulator]{enrollment}.

Number of events for a time-to-event endpoint can vary at different
milestones as more patients are randomized into a trial, or more events
onset over time.

Number of non-missing observations for a non-time-to-event endpoint can vary
at different milestones as more patients are randomized into a trial, or more
patients have been treated until their readout time (thus, \code{NA} turns
to a value).
}
