#' Define an Arm
#'
#' @description
#' Define an arm in a trial. This is a user-friendly wrapper for
#' the class constructor \code{Arm$new}. Users who are not familiar with
#' the concept of classes may consider using this wrapper directly.
#'
#' @param name name of arm, which is the arm's label in generated data
#' @param ... subset condition that is compatible with \code{dplyr::filter}.
#' This can be used to specify inclusion criteria of an arm.
#' By default it is not specified, i.e. all data generated by the generator
# will be used as trial data. More than one conditions can be
#' specified in \code{...}.
#'
#' @examples
#'
#' risk <- data.frame(
#'   end_time = c(1, 10, 26.0, 52.0),
#'   piecewise_risk = c(1, 1.01, 0.381, 0.150) * exp(-3.01)
#' )
#'
#' pfs <- endpoint(name = 'pfs', type='tte',
#' generator = PiecewiseConstantExponentialRNG,
#' risk = risk, endpoint_name = 'pfs')
#'
#' orr <- endpoint(
#'   name = 'orr', type = 'non-tte',
#'   readout = c(orr = 2), generator = rbinom,
#'   size = 1, prob = .4)
#'
#' placebo <- arm(name = 'pbo')
#'
#' placebo$add_endpoints(pfs, orr)
#' placebo
#' head(placebo$get_endpoints()[[1]]$get_generator()(n = 1e3))
#' placebo$get_endpoints()[[2]]$get_name()
#'
#' ## print summary reports for endpoint objects in console
#' # placebo
#'
#' @export
arm <- function(name, ...){

  Arms$new(name = name, ...)

}
