% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.remote.sha.R
\name{get.remote.sha}
\alias{get.remote.sha}
\title{Get Remote SHA}
\usage{
get.remote.sha(owner, repo, ref, seven = TRUE)
}
\arguments{
\item{owner}{repository owner.}

\item{repo}{repository name.}

\item{ref}{reference.}

\item{seven}{whether to truncate SHA reference code to seven characters.}
}
\value{
SHA reference code as a string.
}
\description{
Look up SHA reference code on GitHub.
}
\examples{
\dontrun{
get.remote.sha("ices-tools-prod", "icesAdvice", "master")
get.remote.sha("ices-tools-prod", "icesAdvice", "1.3-0")
get.remote.sha("ices-tools-prod", "icesAdvice", "1.3-0", seven=FALSE)
}

}
\seealso{
\code{\link{taf.boot}} uses \code{get.remote.sha} to determine whether it is
necessary to remove or download files, via \code{\link{clean.library}},
\code{\link{clean.software}}, and \code{\link{download.github}}.

\code{\link{TAF-package}} gives an overview of the package.
}
