% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothT.R
\name{Borda_count}
\alias{Borda_count}
\title{Borda count algorithm for nonparametric tensor estimation with unknown permutation.}
\usage{
Borda_count(A, l, kvec, sym = FALSE)
}
\arguments{
\item{A}{A given (possibly noisy and incomplete) data tensor. Missing value should be encoded as \code{NA}.}

\item{l}{Degree of polynomial approximation.}

\item{kvec}{A vector of the number of groups for each mode.}

\item{sym}{Boolean variables representing symmetricity of the signal tensor. Non-symmetric tensor (\code{sym = FALSE}) is default.}
}
\value{
The returned object is a list of components.

\code{Theta} - An estimated signal tensor based on Borda count estimation.

\code{permutation} - An estimated permutation based on Borda count estimation.
}
\description{
Estimate a signal tensor and permutation from a noisy and incomplete data tensor using Borda count estimation method.
}
\examples{

# Generate the noisy observation from smooth tensor and permutation
d = 20
sim1 = simulation(d,mode = 1)
signal_T = sim1$signal
observe_T = sim1$observe
permutation = sim1$permutation

# Estimate signal tensor and permutation
kvec = c(3,3,3)
result = Borda_count(observe_T,2,kvec,sym = TRUE)

# Calculate MSE
hatTheta = result$Theta
mean((hatTheta-signal_T)^2)

}
\references{
C. Lee and M. Wang. Smooth tensor estimation with unknown permutations. arXiv:2111.04681, 2021.
}
