% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_survey.R
\name{sim_survey_parallel}
\alias{sim_survey_parallel}
\title{Simulate stratified random surveys using parallel computation}
\usage{
sim_survey_parallel(
  sim,
  n_sims = 1,
  n_loops = 100,
  cores = 1,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{sim}{A simulation object returned by \code{\link[=sim_distribution]{sim_distribution()}}.}

\item{n_sims}{Number of surveys to simulate per loop.
Large values may increase memory usage significantly.}

\item{n_loops}{Number of times to call \code{\link[=sim_survey]{sim_survey()}}.
Total number of simulations = \code{n_sims} × \code{n_loops}.
Using a smaller \code{n_sims} and larger \code{n_loops} reduces memory demand but may increase runtime.}

\item{cores}{Number of processor cores to use in parallel. More cores typically reduce total time.}

\item{quiet}{Logical. If \code{FALSE}, prints messages estimating run time.}

\item{...}{
  Arguments passed on to \code{\link[=sim_survey]{sim_survey}}
  \describe{
    \item{\code{q}}{A closure (e.g., \code{\link[=sim_logistic]{sim_logistic()}}) for simulating catchability at age.
Returned values must range between 0 and 1.}
    \item{\code{trawl_dim}}{Trawl width and distance (same units as the grid).}
    \item{\code{resample_cells}}{Logical. If \code{TRUE}, allows grid cells to be resampled.
May introduce bias, as depletion is applied at the cell level.}
    \item{\code{binom_error}}{Logical. Should binomial error be imposed?
If \code{FALSE}, stratified estimates at older ages may be biased due to rounding zeros.}
    \item{\code{min_sets}}{Minimum number of sets per stratum.}
    \item{\code{set_den}}{Set density (sets per grid unit squared).
\strong{Warning:} May error if \code{set_den} is high and \code{resample_cells = FALSE}, because allocated sets may exceed available cells.}
    \item{\code{lengths_cap}}{Maximum number of lengths measured per set.}
    \item{\code{ages_cap}}{Cap on the number of ages to sample, depending on \code{age_sampling} type:
\itemize{
\item If \code{"stratified"}: maximum per length bin (via \code{age_length_group}) and per \code{age_space_group} (e.g., \code{"division"}, \code{"strat"}).
\item If \code{"random"}: maximum number of fish aged per set.
}}
    \item{\code{age_sampling}}{Type of age sampling strategy: \code{"stratified"} (default) or \code{"random"}.}
    \item{\code{age_length_group}}{Width of length bins for stratified age sampling. Ignored if \code{age_sampling = "random"}.}
    \item{\code{age_space_group}}{Spatial scale for stratified age sampling.
Options: \code{"division"} (default), \code{"strat"}, or \code{"set"}. Ignored if \code{age_sampling = "random"}.}
    \item{\code{custom_sets}}{A \code{data.table} of set locations (same structure as returned by \code{\link[=sim_sets]{sim_sets()}}).
If \code{NULL}, set locations are generated automatically.}
    \item{\code{light}}{Logical. If \code{TRUE}, drops some objects from output to reduce memory footprint.}
  }}
}
\value{
A list of the same structure as returned by \code{\link[=sim_survey]{sim_survey()}}, containing the
results of all simulations.
}
\description{
A wrapper around \code{\link[=sim_survey]{sim_survey()}} that enables a much larger number of survey
simulations to be performed using parallel processing. Unlike \code{\link[=test_surveys]{test_surveys()}},
this function retains full survey details and is suitable for evaluating
alternate stratified analysis approaches for generating survey indices.
}
\details{
This function runs \code{\link[=sim_survey]{sim_survey()}} with \code{light = TRUE} to reduce object size
and minimize RAM usage.
}
\examples{
\donttest{
# Run 25 total simulations (5 per loop × 5 loops) over the same population
sim <- sim_abundance(ages = 1:20, years = 1:5) |>
  sim_distribution(grid = make_grid(res = c(10, 10))) |>
  sim_survey_parallel(
    n_sims = 5, n_loops = 5, cores = 1,
    q = sim_logistic(k = 2, x0 = 3),
    quiet = FALSE
  )
}

}
