% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe3.R
\docType{data}
\name{events_SISe3}
\alias{events_SISe3}
\title{Example data to initialize events for the \sQuote{SISe3} model}
\format{
A \code{data.frame}
}
\usage{
data(events_SISe3)
}
\description{
Example data to initialize scheduled events for a population of
1600 nodes and demonstrate the \code{\linkS4class{SISe3}} model.
}
\details{
Example data to initialize scheduled events (see
\code{\linkS4class{SimInf_events}}) for a population of 1600 nodes
and demonstrate the \code{\linkS4class{SISe3}} model. The dataset
contains 783773 events for 1600 nodes distributed over 4 * 365
days. The events are divided into three types: \sQuote{Exit}
events remove individuals from the population (n = 182535),
\sQuote{Enter} events add individuals to the population (n =
182685), \sQuote{Internal transfer} events move individuals
between compartmens within one node e.g. ageing (n = 317081), and
\sQuote{External transfer} events move individuals between nodes
in the population (n = 101472). The vignette contains a detailed
description of how scheduled events operate on a model.
}
\examples{
## For reproducibility, call the set.seed() function and specify
## the number of threads to use. To use all available threads,
## remove the set_num_threads() call.
set.seed(123)
set_num_threads(1)

## Create an 'SISe3' model with 1600 nodes and initialize
## it to run over 4*365 days. Add one infected individual
## to the first node.
data("u0_SISe3", package = "SimInf")
data("events_SISe3", package = "SimInf")
u0_SISe3$I_1[1] <- 1
tspan <- seq(from = 1, to = 4*365, by = 1)
model <- SISe3(u0 = u0_SISe3, tspan = tspan, events = events_SISe3,
               phi = rep(0, nrow(u0_SISe3)), upsilon_1 = 1.8e-2,
               upsilon_2 = 1.8e-2, upsilon_3 = 1.8e-2,
               gamma_1 = 0.1, gamma_2 = 0.1, gamma_3 = 0.1,
               alpha = 1, beta_t1 = 1.0e-1, beta_t2 = 1.0e-1,
               beta_t3 = 1.25e-1, beta_t4 = 1.25e-1, end_t1 = 91,
               end_t2 = 182, end_t3 = 273, end_t4 = 365, epsilon = 0)

## Display the number of individuals affected by each event type
## per day.
plot(events(model))

## Run the model to generate a single stochastic trajectory.
result <- run(model)

## Summarize the trajectory. The summary includes the number of
## events by event type.
summary(result)
}
\keyword{dataset}
