% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgenerate.R
\name{rmvnorm}
\alias{rmvnorm}
\title{Generate data with the multivariate normal (i.e., Gaussian) distribution}
\usage{
rmvnorm(n, mean = rep(0, nrow(sigma)), sigma = diag(length(mean)))
}
\arguments{
\item{n}{number of observations to generate}

\item{mean}{mean vector, default is \code{rep(0, length = ncol(sigma))}}

\item{sigma}{positive definite covariance matrix, default is \code{diag(length(mean))}}
}
\value{
a numeric matrix with columns equal to \code{length(mean)}
}
\description{
Function generates data from the multivariate normal distribution given some mean vector and/or
covariance matrix.
}
\examples{

# random normal values with mean [5, 10] and variances [3,6], and covariance 2
sigma <- matrix(c(3,2,2,6), 2, 2)
mu <- c(5,10)
x <- rmvnorm(1000, mean = mu, sigma = sigma)
head(x)
summary(x)
plot(x[,1], x[,2])


}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{runSimulation}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
