% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgenerate.R
\name{rint}
\alias{rint}
\title{Generate integer values within specified range}
\usage{
rint(n, min, max, replace = TRUE, prob = NULL)
}
\arguments{
\item{n}{number of samples to draw}

\item{min}{lower limit of the distribution. Must be finite}

\item{max}{upper limit of the distribution. Must be finite}

\item{replace}{should sampling be with replacement?}

\item{prob}{a vector of probability weights for obtaining the elements of the vector being sampled}
}
\description{
Efficiently generate positive and negative integer values with (default) or without replacement.
This function is mainly a wrapper to the \code{\link{sample.int}} function (which itself is much
more efficient integer sampler than the more general \code{\link{sample}}), however is intended
to work with both positive and negative integer ranges since \code{sample.int} only returns
positive integer values that must begin at \code{1L}.
}
\examples{

set.seed(1)

# sample 1000 integer values within 20 to 100
x <- rint(1000, min = 20, max = 100)
summary(x)

# sample 1000 integer values within 100 to 10 billion
x <- rint(1000, min = 100, max = 1e8)
summary(x)

# compare speed to sample()
system.time(x <- rint(1000, min = 100, max = 1e8))
system.time(x2 <- sample(100:1e8, 1000, replace = TRUE))

# sample 1000 integer values within -20 to 20
x <- rint(1000, min = -20, max = 20)
summary(x)

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
