% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAFbound.R
\name{GAFbound}
\alias{GAFbound}
\title{Generalized assumption-free bound}
\usage{
GAFbound(whichEst, M, m, outcome, treatment, selection = NULL)
}
\arguments{
\item{whichEst}{Input string. Defining the causal estimand of interest.
Available options are as follows. (1) Relative risk in the total
population: "RR_tot", (2) Risk difference in the total population:
"RD_tot", (3) Relative risk in the subpopulation: "RR_sub", (4) Risk
difference in the subpopulation: "RD_sub".}

\item{M}{Input value. Sensitivity parameter. Must be between 0 and 1, larger
than m and larger than max_t P(Y=1|T=t,I_s=1).}

\item{m}{Input value. Sensitivity parameter. Must be between 0 and 1, smaller
than M and smaller than min_t P(Y=1|T=t,I_s=1).}

\item{outcome}{Input vector. A binary outcome variable. Either the data
vector (length>=3) or two conditional outcome probabilities with
P(Y=1|T=1,I_s=1) and P(Y=1|T=0,I_s=1) as first and second element.}

\item{treatment}{Input vector. A binary treatment variable. Either the data
vector (length>=3) or two conditional treatment probabilities with
P(T=1|I_s=1) and P(T=0|I_s=1) as first and second element.}

\item{selection}{Input vector or input scalar. A binary selection variable or
a selection probability. Can be omitted for subpopulation estimands.}
}
\value{
A list containing the upper and lower GAF bounds.
}
\description{
\code{GAFbound()} returns a list with the GAF upper and lower bounds. The
sensitivity parameters can be inserted directly or as output from
\code{sensitivityparametersM()}.
}
\examples{

# Example with selection indicator variable.
y = c(0, 0, 0, 0, 1, 1, 1, 1)
tr = c(0, 0, 1, 1, 0, 0, 1, 1)
sel = c(0, 1, 0, 1, 0, 1, 0, 1)
Mt = 0.8
mt = 0.2
GAFbound(whichEst = "RR_tot", M = Mt, m = mt, outcome = y, treatment = tr,
 selection = sel)

# Example with selection probability.
selprob = mean(sel)
GAFbound(whichEst = "RR_tot", M = Mt, m = mt, outcome = y[sel==1],
 treatment = tr[sel==1], selection = selprob)

# Example with subpopulation and no selection variable or probability.
Ms = 0.7
ms = 0.1
GAFbound(whichEst = "RR_sub", M = Ms, m = ms, outcome = y, treatment = tr)

# Example with simulated data.
n = 1000
tr = rbinom(n, 1, 0.5)
y = rbinom(n, 1, 0.2 + 0.05 * tr)
sel = rbinom(n, 1, 0.4 + 0.1 * tr + 0.3 * y)
Mt = 0.5
mt = 0.05
GAFbound(whichEst = "RD_tot", M = Mt, m = mt, outcome = y, treatment = tr,
 selection = sel)

}
\references{
Zetterstrom, Stina. "Bounds for selection bias using outcome
probabilities" Epidemiologic Methods 13, no. 1 (2024): 20230033
}
