% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.SSN2}
\alias{tidy.SSN2}
\alias{tidy.ssn_lm}
\alias{tidy.ssn_glm}
\title{Tidy a fitted model object}
\usage{
\method{tidy}{ssn_lm}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)

\method{tidy}{ssn_glm}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval
in the tidied output. The default is \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int} is \code{TRUE}. Must be strictly greater than 0 and less than 1.
The default is 0.95, which corresponds to a 95 percent confidence interval.}

\item{effects}{The type of effects to tidy. Available options are \code{"fixed"}
(fixed effects), \code{"tailup"} (tailup covariance parameters),
\code{"taildown"} (taildown covariance parameters), \code{"euclid"} (Euclidean
covariance parameters), \code{"nugget"} (nugget covariance parameter),
\code{"dispersion"} (dispersion parameter if relevant), \code{"ssn"} for all
of \code{"tailup"}, \code{"taildown"}, \code{"euclid"}, \code{"nugget"}, and
\code{"dispersion"}, and \code{"randcov"} (random effect variances). The default is \code{"fixed"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tidy tibble of summary information \code{effects}.
}
\description{
Tidy a fitted model object into a summarized tibble.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
tidy(ssn_mod)
}
\seealso{
\code{\link[=glance.SSN2]{glance.SSN2()}} \code{\link[=augment.SSN2]{augment.SSN2()}}
}
