% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembl_funcs.R
\name{findRSID}
\alias{findRSID}
\title{Query Ensembl for variant information based on genomic position}
\usage{
findRSID(
  chromosome,
  start_position,
  end_position = NULL,
  build = "38",
  file_path = NULL
)
}
\arguments{
\item{chromosome}{Numeric, specifying the chromosome number.}

\item{start_position}{Numeric, specifying the starting base pair position.}

\item{end_position}{Numeric, specifying the ending base pair position.}

\item{build}{Numeric, specifying the genomic build, default value is 38.}

\item{file_path}{character, path to a file for saving results as Excell spreadsheet.}
}
\value{
A \code{data.table} containing variant information including:
\itemize{
\item \code{id}: variant id in rsID format
\item \code{alleles}: variant alleles
\item \code{seq_region_name}: chromosome number
\item \code{start}: starting base pair
\item \code{end}: ending base pair
}
}
\description{
This function retrieves variant information from Ensembl based on the specified genomic position.
It takes the chromosome number, start position, and end position as input parameters and searches
for variants within this window, using the specified genomic build.
If only the start position is provided, the function automatically sets the end position equal
to the start position. This is particularly relevant for SNP variants, where the start and
end positions are the same. The function returns all variants found within the defined window.
}
