% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{sample.table}
\alias{sample.table}
\title{phyloseq-styled sample table}
\usage{
sample.table(fractions_df)
}
\arguments{
\item{fractions_df}{fractions data frame
A fractions file with the following columns
\itemize{
\item Replicate: Depends on how many replicates the study has
\item Fractions: Typically in the range of 2-24
\item Buoyant_density: As calculated from the refractometer for each fraction and replicate
\item Isotope: "12C", "13C", "14N", "15N" etc.
\item DNA_concentration
\item Sample: In the format "'isotope'\emph{rep}#\emph{fraction}#".
For instance, "12C_rep_1_fraction_1"
}}
}
\value{
data  frame: phyloseq-style sample table
}
\description{
Creates a phyloseq-styled sample table from fractions metadata
containing data on fraction number, number of replicates, buoyant density
calculated from a refractometer, type of isotope, and DNA concentration
of each fraction, and isotope type. See below for information on "fractions" file.
}
\examples{
data(fractions)

\donttest{

### Making phyloseq table from fractions metadata
samples.object = sample.table(fractions)
}
}
