% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_prediction.R
\name{pred_target_shp}
\alias{pred_target_shp}
\title{Predictive Target over a Shapefile}
\usage{
pred_target_shp(
  object,
  shp,
  shp_target = mean,
  weights = NULL,
  standardize_weights = FALSE,
  col_names = NULL,
  include_covariates = TRUE,
  include_nugget = FALSE,
  include_cov_offset = FALSE,
  include_re = FALSE,
  f_target = NULL,
  pd_summary = NULL
)
}
\arguments{
\item{object}{Output from `pred_over_grid`, a RiskMap.pred.re object.}

\item{shp}{Spatial dataset (sf or data.frame) representing the shapefile over which predictions are computed.}

\item{shp_target}{Function defining the aggregation method for shapefile targets (default is mean).}

\item{weights}{Optional numeric vector of weights for spatial predictions.}

\item{standardize_weights}{Logical indicating whether to standardize weights (default is FALSE).}

\item{col_names}{Column name or index in 'shp' containing region names.}

\item{include_covariates}{Logical indicating whether to include covariates in predictions (default is TRUE).}

\item{include_nugget}{Logical indicating whether to include the nugget effect (default is FALSE).}

\item{include_cov_offset}{Logical indicating whether to include covariate offset in predictions (default is FALSE).}

\item{include_re}{Logical indicating whether to include random effects in predictions (default is FALSE).}

\item{f_target}{List of target functions to apply to the linear predictor samples.}

\item{pd_summary}{List of summary functions (e.g., mean, sd) to summarize target samples.}
}
\value{
An object of class 'RiskMap_pred_target_shp' containing computed targets,
summaries, and associated spatial data.
}
\description{
Computes predictions over a shapefile using outputs from the
\code{\link{pred_over_grid}} function.
This function allows for incorporating covariates, offsets, and optional
unstructured random effects into the predictive target.
}
\details{
This function computes predictive targets or summaries over a spatial shapefile
using outputs from 'pred_S'. It requires the 'terra' package for spatial data
manipulation and should be used with 'sf' or 'data.frame' objects representing
the shapefile.
}
\seealso{
\code{\link{pred_target_grid}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
