% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{matern_cor}
\alias{matern_cor}
\title{Matern Correlation Function}
\usage{
matern_cor(u, phi, kappa, return_sym_matrix = FALSE)
}
\arguments{
\item{u}{A vector of distances between pairs of data locations.}

\item{phi}{The scale parameter \eqn{\phi}.}

\item{kappa}{The smoothness parameter \eqn{\kappa}.}

\item{return_sym_matrix}{A logical value indicating whether to return a symmetric correlation matrix. Defaults to \code{FALSE}.}
}
\value{
A vector of the same length as \code{u} with the values of the Matern correlation function for the given distances, if \code{return_sym_matrix=FALSE}. If \code{return_sym_matrix=TRUE}, a symmetric correlation matrix is returned.
}
\description{
Computes the Matern correlation function.
}
\details{
The Matern correlation function is defined as
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
\deqn{\rho(u; \phi; \kappa) = (2^{\kappa-1})^{-1}(u/\phi)^\kappa K_{\kappa}(u/\phi)}
where \eqn{\phi} and \eqn{\kappa} are the scale and smoothness parameters, and \eqn{K_{\kappa}(\cdot)} denotes the modified Bessel function of the third kind of order \eqn{\kappa}. The parameters \eqn{\phi} and \eqn{\kappa} must be positive.
}
