% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_nonlinear_LAPEIG.R
\name{do.lapeig}
\alias{do.lapeig}
\title{Laplacian Eigenmaps}
\usage{
do.lapeig(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters including \describe{
\item{kernelscale}{kernel scale parameter. Default value is 1.0.}
\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"null"}. See also \code{\link{aux.preprocess}} for more details.}
\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}
\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}
\item{weighted}{a logical; \code{TRUE} for weighted graph laplacian and \code{FALSE} for
combinatorial laplacian where connectivity is represented as 1 or 0 only.}
}}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{eigvals}{a vector of eigenvalues for laplacian matrix.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\code{do.lapeig} performs Laplacian Eigenmaps (LE) to discover low-dimensional
manifold embedded in high-dimensional data space using graph laplacians. This
is a classic algorithm employing spectral graph theory.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## try different levels of connectivity
out1 <- do.lapeig(X, type=c("proportion",0.5), weighted=FALSE)
out2 <- do.lapeig(X, type=c("proportion",0.10), weighted=FALSE)
out3 <- do.lapeig(X, type=c("proportion",0.25), weighted=FALSE)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=lab, main="5\% connected")
plot(out2$Y, pch=19, col=lab, main="10\% connected")
plot(out3$Y, pch=19, col=lab, main="25\% connected")
par(opar)
}

}
\references{
\insertRef{belkin_laplacian_2003}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
