% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_preprocess.R
\name{aux.preprocess}
\alias{aux.preprocess}
\title{Preprocessing the data}
\usage{
aux.preprocess(
  data,
  type = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{type}{one of \code{"center"}, \code{"scale"}, \code{"cscale"}, \code{"decorrelate"} or \code{"whiten"}.}
}
\value{
named list containing:
\describe{
\item{pX}{an \eqn{(n\times p)} matrix after preprocessing in accordance with \code{type} parameter}
\item{info}{a list containing \itemize{
\item \code{type:} name of preprocessing procedure.
\item \code{mean:} a mean vector of length \eqn{p}.
\item \code{multiplier:} a \eqn{(p\times p)} matrix or 1 for "center".}}
}
}
\description{
\code{aux.preprocess} can perform one of following operations; \code{"center"}, \code{"scale"},
\code{"cscale"}, \code{"decorrelate"} and \code{"whiten"}. See below for more details.
}
\section{Operations}{
 we have following operations,
 \describe{
 \item{\code{"center"}}{subtracts mean of each column so that every variable has mean \eqn{0}.}
 \item{\code{"scale"}}{turns each column corresponding to variable have variance \eqn{1}.}
 \item{\code{"cscale"}}{combines \code{"center"} and \code{"scale"}.}
 \item{\code{"decorrelate"}}{\code{"center"} and sets its covariance term having diagonal entries only.}
 \item{\code{"whiten"}}{\code{"decorrelate"} and sets all diagonal elements be \eqn{1}.}
 }
}

\examples{
\donttest{
## Generate data
set.seed(100)
X = aux.gensamples(n=200)

## 5 types of preprocessing
X_center = aux.preprocess(X)
X_scale  = aux.preprocess(X,type="scale")
X_cscale = aux.preprocess(X,type="cscale")
X_decorr = aux.preprocess(X,type="decorrelate")
X_whiten = aux.preprocess(X,type="whiten")
}

}
\author{
Kisung You
}
