% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ICA.R
\name{do.ica}
\alias{do.ica}
\title{Independent Component Analysis}
\usage{
do.ica(
  X,
  ndim = 2,
  type = "logcosh",
  tpar = 1,
  sym = FALSE,
  tol = 1e-06,
  redundancy = TRUE,
  maxiter = 100
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{nonquadratic function, one of \code{"logcosh"},\code{"exp"}, or \code{"poly"} be chosen.}

\item{tpar}{a numeric parameter for \code{logcosh} and \code{exp} parameters that should be close to 1.}

\item{sym}{a logical value; \code{FALSE} for not using symmetric decorrelation, \code{TRUE} otherwise.}

\item{tol}{stopping criterion for iterative update.}

\item{redundancy}{a logical value; \code{TRUE} for removing \code{NA} values after prewhitening, \code{FALSE} otherwise.}

\item{maxiter}{maximum number of iterations allowed.

\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}}
}
\description{
\code{do.ica} is an R implementation of FastICA algorithm, which aims at
finding weight vectors that maximize a measure of non-Gaussianity of projected data.
FastICA is initiated with pre-whitening of the data. Single and multiple component
extraction are both supported. For more detailed information on ICA and FastICA algorithm,
see this \href{https://en.wikipedia.org/wiki/FastICA}{Wikipedia} page.
}
\details{
In most of ICA literature, we have \deqn{S = X*W} where \eqn{W} is an unmixing matrix for
the given data \eqn{X}. In order to preserve consistency throughout our package, we changed
the notation; \eqn{Y} a projected matrix for \eqn{S}, and \code{projection} for unmixing matrix \eqn{W}.
}
\examples{
## use iris dataset
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## 1. use logcosh function for transformation
output1 <- do.ica(X,ndim=2,type="logcosh")

## 2. use exponential function for transformation
output2 <- do.ica(X,ndim=2,type="exp")

## 3. use polynomial function for transformation
output3 <- do.ica(X,ndim=2,type="poly")

## Visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, col=lab, pch=19, main="ICA::logcosh")
plot(output2$Y, col=lab, pch=19, main="ICA::exp")
plot(output3$Y, col=lab, pch=19, main="ICA::poly")
par(opar)

}
\references{
\insertRef{hyvarinen_independent_2001}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
