% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_FA.R
\name{do.fa}
\alias{do.fa}
\title{Exploratory Factor Analysis}
\usage{
do.fa(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued number of loading variables, or target dimension.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 10).}
\item{tolerance}{stopping criterion in a Frobenius norm (default: 1e-8).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{loadings}{a \eqn{(p\times ndim)} matrix whose rows are extracted loading factors.}
\item{noise}{a length-\eqn{p} vector of estimated noise.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
\code{do.fa} is an optimization-based implementation of a popular technique for Exploratory Data Analysis.
It is closely related to principal component analysis.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## compare with PCA and MDS
out1 <- do.fa(X, ndim=2)
out2 <- do.mds(X, ndim=2)
out3 <- do.pca(X, ndim=2)

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=lab, main="Factor Analysis")
plot(out2$Y, pch=19, col=lab, main="MDS")
plot(out3$Y, pch=19, col=lab, main="PCA")
par(opar)
}

}
\references{
\insertRef{spearman_general_1904}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
