% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQF.plot.R
\name{EQF.plot}
\alias{EQF.plot}
\title{EQF plot}
\usage{
EQF.plot(result, plot.all = TRUE, plot.chr = TRUE, plot.main = TRUE)
}
\arguments{
\item{result}{list. The data list of the output from LOD.QTLdetect(),
EQF.permu(), or Qhot.EQF().}

\item{plot.all}{logical. When set to TRUE, it directs the function to
output one figure of the EQF values over the bins.}

\item{plot.chr}{logical. When set to TRUE, it instructs the function to
output the figures of the EQF values over the bins for each chromosome.}

\item{plot.main}{logical of character. When set to TRUE, it will use the
default title on the plot. When set to FALSE, it will be no title on the
plot. Users can also use this argument to set their own title.}
}
\value{
One or several EQF plots.
}
\description{
Generate an EQF plot based on the result of the permutation process
used to detect the QTL hotspot.
}
\examples{
# load the example data
load(system.file("extdata", "LODexample.RDATA", package = "QTLEMM"))

# run and result
EQF.plot(LOD.QTLdetect.result)
EQF.plot(EQF.permu.result)
}
\references{
Wu, P.-Y., M.-.H. Yang, and C.-H. KAO 2021 A Statistical Framework
for QTL Hotspot Detection. G3: Genes, Genomes, Genetics: jkab056. <doi: 10.1093/g3journal/jkab056>
}
\seealso{
\code{\link[QTLEMM]{LOD.QTLdetect}}
\code{\link[QTLEMM]{EQF.permu}}
\code{\link[QTLEMM]{Qhot.EQF}}
}
