% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_final_module}
\alias{get_final_module}
\title{Get final module.}
\usage{
get_final_module(
  index,
  edge,
  mut_status,
  sur,
  seed,
  cutoff = 0.05,
  max.size.local = 500,
  max.size.candidate = 200,
  rate = 0.05,
  perm = 1000
)
}
\arguments{
\item{index}{A index file of PPI networks,downloaded from http://compbio-research.cs.brown.edu/pancancer/hotnet2/.}

\item{edge}{The edge lists of PPI networks,downloaded from http://compbio-research.cs.brown.edu/pancancer/hotnet2/.}

\item{mut_status}{The mutations matrix,generated by `get_mut_status`.}

\item{sur}{A nx2 data frame of samples' survival data,the first line is samples' survival event and the second line is samples' overall survival.}

\item{seed}{The canonical drivers from NCG database, which use as the starting node of the greedy algorithm.}

\item{cutoff}{The perturbed p-value cutoff point,default is 0.05.}

\item{max.size.local}{The size of maximum connected local network,default is 500.}

\item{max.size.candidate}{The maximum size of the candidate module,default is 200.}

\item{rate}{The rate of increase in score,default is 0.05.}

\item{perm}{The perturbation number,default is 1000.}
}
\value{
The final module.
}
\description{
The function `get_final_module` is used to identify the final module.
}
\examples{
\donttest{#load the data
indexdata<-system.file("extdata","hint+hi2012_index_file.txt",package="ProgModule")
index<-read.table(indexdata,sep="\t",header=FALSE)
edgedata<-system.file("extdata","hint+hi2012_edge_file.txt",package="ProgModule")
edge<-read.table(edgedata,sep="\t",header=FALSE)
data(mut_status)
sur<-system.file("extdata","sur.csv",package ="ProgModule")
sur<-read.delim(sur,sep=",",header=TRUE,row.names=1)
canonical_drivers<-system.file("extdata","canonical_drivers.txt",package="ProgModule")
seed_gene<-read.table(canonical_drivers,header=FALSE)
#perform the function `get_final_module`.
finalmodule.example<-get_final_module(index,edge,mut_status,sur,seed=seed_gene,
cutoff=0.05,max.size.local=500,max.size.candidate=200,rate=0.05,perm=100)}
}
