% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_threshold}
\alias{filter_threshold}
\title{Filter by Threshold Value}
\usage{
filter_threshold(signal_df, value, type = c("above", "below"))
}
\arguments{
\item{signal_df}{Data frame with signal values}

\item{value}{Threshold value}

\item{type}{"above" or "below"}
}
\value{
Binary selection matrix
}
\description{
Selects stocks above or below a threshold value.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
# Select stocks with positive momentum
positive <- filter_threshold(momentum, 0, type = "above")
}
