% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{init.EM.lasso}
\alias{init.EM.lasso}
\title{Initialization of the shifts using Lasso.}
\usage{
init.EM.lasso(
  phylo,
  Y_data,
  Y_data_imp = Y_data,
  Y_data_vec_known = as.vector(Y_data),
  process,
  times_shared = compute_times_ca(phylo),
  distances_phylo,
  nbr_of_shifts,
  K_lag_init = 0,
  use_sigma = TRUE,
  params_sigma = NULL,
  variance.init = diag(1, p, p),
  random.init = FALSE,
  value.root.init = rep(0, p),
  exp.root.init = rep(1, p),
  var.root.init = diag(1, p, p),
  edges.init = NULL,
  values.init = matrix(0, p, length(edges.init)),
  relativeTimes.init = NULL,
  selection.strength.init = 1,
  optimal.value.init = rep(0, p),
  T_tree = incidence.matrix(phylo),
  subtree.list = NULL,
  miss = FALSE,
  sBM_variance = FALSE,
  stationary.root.init = FALSE,
  masque_data,
  independent = FALSE,
  ...
)
}
\arguments{
\item{Y_data}{data at the tips.}

\item{times_shared}{(matrix) : times of shared ancestry, result of function 
\code{compute_times_ca}.}

\item{distances_phylo}{(matrix) : phylogenetic distance, result of function 
\code{compute_dist_phy}}

\item{nbr_of_shifts}{number of shifts used in the EM algorithm}
}
\value{
params_init the list of initial parameters to be used, in the right
 format.
}
\description{
\code{init.EM.lasso} does the following regression :
||Y_data-T.delta||_(Sigma_YY^(-1)) + lambda |delta|_1
using the function \code{glmnet::glmnet} of package \code{glmnet},
through function \code{lasso_regression_K_fixed}. 
T is the incidence matrix of the tree, and 
delta the vectorial representation of the shifts (see functions 
\code{incidence.matrix} and \code{shifts.list_to_vector} for further details).
}
\details{
A Cholesky decomposition of function Sigma_YY^(-1) is used.
lambda is chosen so that delta has the right number of non zero components.
}
\keyword{internal}
