% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_array.R
\name{unsupervised_clustering_auto_m_c,omics_array-method}
\alias{unsupervised_clustering_auto_m_c,omics_array-method}
\alias{unsupervised_clustering_auto_m_c}
\title{Cluster a omics_array object: determine optimal fuzzification parameter and
number of clusters.}
\usage{
\S4method{unsupervised_clustering_auto_m_c}{omics_array}(
  M1,
  clust = NULL,
  mestim = NULL,
  M2 = NULL,
  data_log = TRUE,
  screen = NULL,
  crange = NULL,
  repeats = NULL,
  cselect = TRUE,
  dminimum = FALSE
)
}
\arguments{
\item{M1}{Object of omics_array class.}

\item{clust}{[NULL] Number of clusters.}

\item{mestim}{[NULL] Fuzzification parameter.}

\item{M2}{[NULL] Object of omics_array class,}

\item{data_log}{[TRUE] Should data be logged?}

\item{screen}{[NULL] Specify `screen` parameter.}

\item{crange}{[NULL] Specify `crange` parameter.}

\item{repeats}{[NULL] Specify `repeats` parameter.}

\item{cselect}{[TRUE] Estimate `cselect` parameter.}

\item{dminimum}{[FALSE] Estimate `dminimum` parameter.}
}
\value{
\item{m}{Estimate of the optimal fuzzification parameter.}
\item{c}{Estimate of the optimal number of clusters.} \item{csearch}{More
result from the cselection function of the Mfuzz package}
}
\description{
Based on soft clustering performed by the Mfuzz package.
}
\examples{

if(require(CascadeData)){
data(micro_S, package="CascadeData")
M<-as.omics_array(micro_S[1:100,],1:4,6)
mc<-unsupervised_clustering_auto_m_c(M)
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{cluster}
