% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U01-data-validation.R
\name{validate_PSsurvdiff_inputs}
\alias{validate_PSsurvdiff_inputs}
\title{Validate All Inputs for PSsurvdiff}
\usage{
validate_PSsurvdiff_inputs(
  data,
  ps_formula,
  censor_formula,
  weight_method,
  censor_method,
  trim_alpha,
  trim_q,
  time_points,
  conf_level,
  ps_control,
  censor_control,
  bootstrap_control
)
}
\arguments{
\item{data}{A data.frame containing the analysis data.}

\item{ps_formula}{Formula object for propensity score model.}

\item{censor_formula}{Formula object for censoring model.}

\item{weight_method}{Character string specifying weighting method.}

\item{censor_method}{Character string specifying censoring method.}

\item{trim_alpha}{Numeric, symmetric trimming threshold.}

\item{trim_q}{Numeric, asymmetric trimming quantile.}

\item{time_points}{Numeric vector or NULL.}

\item{conf_level}{Numeric, confidence level.}

\item{ps_control}{List of PS model control parameters.}

\item{censor_control}{List of censoring model control parameters.}

\item{bootstrap_control}{List of bootstrap control parameters or NULL.}
}
\value{
A list containing:
  \item{data_clean}{Data frame with complete cases only}
  \item{treatment_var}{Character string of treatment variable name}
  \item{time_var}{Character string of time variable name (possibly an expression)}
  \item{event_var}{Character string of event variable name (possibly an expression)}
  \item{censor_formula}{The validated censoring formula, or NULL if no censoring
    adjustment was requested (i.e., original formula had RHS of 0)}
  \item{n_complete}{Integer, number of complete cases used in analysis}
}
\description{
Umbrella function that calls all validation functions and returns the
cleaned dataset with complete cases ready for model fitting.
}
\keyword{internal}
