% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_integerate.R
\name{update_RT}
\alias{update_RT}
\title{Manually Update Observed RT for either all compounds, all next samples, or single compound and sample}
\usage{
update_RT(
  chrom_res,
  compound_id,
  sample_id = NULL,
  peak_start,
  peak_end,
  manual = FALSE,
  target = "single",
  force = FALSE
)
}
\arguments{
\item{chrom_res}{ChromRes object}

\item{compound_id}{Compound ID}

\item{sample_id}{Sample ID}

\item{peak_start}{Minimum RT value}

\item{peak_end}{Maximum RT value}

\item{manual}{Manual update. Default is FALSE}

\item{target}{Target of update. Options are "single", "all", "all_next"}

\item{force}{Force update if previous peak exists. Default is FALSE}
}
\description{
Update RT for either all compounds, all next samples, or single compound and sample
}
\details{
Only target = "all" will update the expected RT for all compounds.
}
\examples{
\dontrun{
update_RT(chrom_res, compound_id = 1, sample_id = 1, 
          peak_start = 1, peak_end = 2, target = "single")
}
}
