% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.e.density.R
\name{kernel.e.density}
\alias{kernel.e.density}
\title{Epanechnikov kernel density estimation}
\usage{
kernel.e.density(data, points, h)
}
\arguments{
\item{data}{vector of observations}

\item{points}{in which the function is evaluated}

\item{h}{bandwidth}
}
\value{
density estimation
}
\description{
Estimates the density function using the Epanechnikov kernel
}
\examples{
x = rnorm(100,1,2)
gridd = seq(-5,5,length.out=1000)
h = (4/3)^(1/5)*sd(x)*length(x)^(-1/5)
kernel.e.density (x,gridd,h)
}
