% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subcascades.R
\name{subcascades}
\alias{subcascades}
\title{Subcascades Evaluation}
\usage{
subcascades(
  predictionMap = NULL,
  sets = NULL,
  thresh = 0,
  size = NA,
  numSol = 1000
)
}
\arguments{
\item{predictionMap}{A PredictionMap object as it is returned by \code{\link{predictionMap}}-function. 
It is made up of a list of two matrices(pred and meta). Both matrices provide information on individual samples column-wise.
The rownames of the pred-matrix (e.g. [0vs1]) show the classes of the binary base classifier. The elements are the prediction result of a specific training.
The rows that correspond to base classifiers that would separate the same class consists of -1. Those rows are not used within the analysis.
The meta information connects the values in the pred-matrix to a specific fold, run and contains the original label.}

\item{sets}{Contains the set used for filtering. It is either a list of numeric vectors, a numeric vector, 
or a vector of characters representing a cascade of the following format '1>2>4'. Empty vectors are not allowed.}

\item{thresh}{A numeric value between 0 and 1.
The minimal sensitivity threshold used to filter the returned cascades. 
Only cascades that pass this threshold are returned. 
If 0 is used the returned cascades are filtered for >0 and otherwise >= thresh.
For low thresholds the calculation lasts longer.}

\item{size}{A numeric value that defines the size of the cascades that should be returned. 
The smallest size is 2 and the largest the maximal number of classes of the current dataset.
If size is NA (the default setting), all cascades from 2 to the maximal number of classes are evaluated.}

\item{numSol}{The maximum number of cascades that should pass the first sensitivity bound and are 
further evaluated.}
}
\value{
A Subcascades object comprising the evaluated cascades and their performances. 
The Subcascades object is made up of a list of matrices. 
Each matrix comprises the evaluation results of cascades of a specific length and 
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.
}
\description{
\code{Subcascades} returns all cascades found within the data or evaluates a set of specific cascades.
}
\details{
This function can either be used to evaluate the performance of a specific cascade, a set of cascades or 
to filter out the set of cascades of a specific size and passing a given threshold. 
If the sets-variable is given no size can be set.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(),  kernel='linear')

# use default parameter settings 
# -> returns cascades of all lengths that show a minimal classwise sensitivity >0.
subc = subcascades(predMap)
# change the threshold 
# -> returns cascades of all lengths that show a minimal classwise sensitivity >=0.6.
subc = subcascades(predMap, thresh=0.6)
# search only for cascades of length 2 and 4 
# -> returns cascades of length 2 and 4 that show a minimal classwise sensitivity >=0.6.
subc = subcascades(predMap, thresh=0.6, size=c(2,4))
# evaluates the performance of the cascade '0>1>2>3>4'.
subc = subcascades(predMap, sets = c('0>1>2>3>4'))
}
\seealso{
\code{\link{print.Subcascades}}, \code{\link{plot.Subcascades}}, \code{\link{summary.Subcascades}}
}
