% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{mammals_brain_body_df}
\alias{mammals_brain_body_df}
\title{Mammal Brain and Body Size}
\format{
A data frame with 96 observations and 5 variables:
\describe{
  \item{Species}{Factor with 96 levels: Mammalian species names}
  \item{Brain}{Numeric: Brain weight (grams)}
  \item{Body}{Numeric: Body weight (kilograms)}
  \item{Gestation}{Integer: Gestation period (days)}
  \item{Litter}{Numeric: Average litter size}
}
}
\source{
Data taken from the Sleuth3 package version 1.0-6. Original study:
Allison, T. and Cicchetti, D.V. (1976) Sleep in Mammals: Ecological and
Constitutional Correlates. \emph{Science}, 194, 732-734.
}
\usage{
data(mammals_brain_body_df)
}
\description{
This dataset, mammals_brain_body_df, is a data frame containing comparative
neuroanatomical and life history data for 96 mammalian species. The data examine
the relationship between brain size, body size, and reproductive characteristics
across different mammal species.
}
\details{
The dataset name has been kept as 'mammals_brain_body_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
