# Licensing Information for `NeuroDataSets` Package

This package, `NeuroDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **parkinsons_dopamine_list**: 
  Originally parkinsons from the bnma package, licensed under GPL-3. The dataset name has been changed to 'parkinsons_dopamine_list' to indicate that this dataset is a list object.

- **gm_expected_patterns_tbl_df**: 
  Originally EP.GM from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'gm_expected_patterns_tbl_df' to indicate that this dataset is a tibble object.    

- **subcortical_patterns_tbl_df**:
  Originally EP.Subcortical from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'subcortical_patterns_tbl_df' to indicate that this dataset is a tibble object.

- **white_matter_patterns_tbl_df**: 
  Originally EP.WM from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'white_matter_patterns_tbl_df' to indicate that this dataset is a tibble object.   

- **hippocampus_lesions_df**: 
  Originally HippocampusLesions from the abd package, licensed under GPL-2. The dataset name has been changed to 'hippocampus_lesions_df' to indicate that this dataset is a data frame object.     

- **bilingual_brains_df**: 
  Originally LanguageBrains from the abd package, licensed under GPL-2. The dataset name has been changed to 'bilingual_brains_df' to indicate that this dataset is a data frame object.   

- **neanderthal_brains_df**: 
  Originally NeanderthalBrains from the abd package, licensed under GPL-2. The dataset name has been changed to 'neanderthal_brains_df' to indicate that this dataset is a data frame object.   

- **sleep_performance_df**: 
  Originally SleepAndPerformance from the abd package, licensed under GPL-2. The dataset name has been changed to 'sleep_performance_df' to indicate that this dataset is a data frame object.   

- **cocaine_dopamine_df**: 
  Originally CocaineDopamine from the abd package, licensed under GPL-2. The dataset name has been changed to 'cocaine_dopamine_df' to indicate that this dataset is a data frame object.   

- **alzheimers_biomarkers_tbl_df**: 
  Originally ad_data from the modeldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'alzheimers_biomarkers_tbl_df' to indicate that this dataset is a tibble object.   

- **alzheimer_smoking_df**: 
  Originally alzheimer from the coin package, licensed under GPL-2. The dataset name has been changed to 'alzheimer_smoking_df' to indicate that this dataset is a data frame object.  

- **brains_cognitive_matrix**: 
  Originally cogdat from the RRMLRfMC package, licensed under GPL-2. The dataset name has been changed to 'brains_cognitive_matrix' to indicate that this dataset is a matrix object.  

- **neuro_pointprocess_matrix**: 
  Originally neuro from the boot package, licensed under Unlimited. The dataset name has been changed to 'neuro_pointprocess_matrix' to indicate that this dataset is a matrix object.  

- **guineapig_neurotransmission_df**: 
  Originally paulsen from the boot package, licensed under Unlimited. The dataset name has been changed to 'guineapig_neurotransmission_df' to indicate that this dataset is a data frame object.   

- **brain_size_iq_df**: 
  Originally Brainsz from the sur package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_size_iq_df' to indicate that this dataset is a data frame object.   

- **mammals_brain_body_df**: 
  Originally case0902 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'mammals_brain_body_df' to indicate that this dataset is a data frame object.   

- **blood_brain_barrier_df**: 
  Originally case1102 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'blood_brain_barrier_df' to indicate that this dataset is a data frame object.   

- **brain_litter_mammals_df**: 
  Originally ex0333 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_litter_mammals_df' to indicate that this dataset is a data frame object.   

- **brain_string_players_df**: 
  Originally ex0728 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_string_players_df' to indicate that this dataset is a data frame object.  

- **oasis_dementia_mri_df**: 
  Originally oasis from the jointest package, licensed under GPL-2. The dataset name has been changed to 'oasis_dementia_mri_df' to indicate that this dataset is a data frame object.   

- **epilepsy_drug_qol_df**: 
  Originally epileptic.qol from the joineRML package, licensed under GPL-3 | file LICENSE. The dataset name has been changed to 'epilepsy_drug_qol_df' to indicate that this dataset is a data frame object.  

- **epilepsy_drug_trial_df**: 
  Originally epilepsy from the faraway package, licensed under GPL. The dataset name has been changed to 'epilepsy_drug_trial_df' to indicate that this dataset is a  data frame object.   

- **aba_phenotype_data_df**: 
  Originally aba_pheno_data from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'aba_phenotype_data_df' to indicate that this dataset is a data frame object.   

- **markers_human_brain_df**: 
  Originally markers_df_human_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_human_brain_df' to indicate that this dataset is a data frame object.   

- **markers_mouse_brain_df**: 
  Originally markers_df_mouse_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_mouse_brain_df' to indicate that this dataset is a data frame object.  

- **markers_brain_df**: 
  Originally markers_df_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_brain_df' to indicate that this dataset is a data frame object.   

- **epilepsy_RCT_tbl_df**: 
  Originally Thall from the pubh package, licensed under GPL-2. The dataset name has been changed to 'epilepsy_RCT_tbl_df' to indicate that this dataset is a data frame object.   

- **adolescent_mental_health_df**: 
  Originally AddHealth from the heplots package, licensed under GPL (>= 2). The dataset name has been changed to 'adolescent_mental_health_df' to indicate that this dataset is a data frame object. 

- **neurocognitive_psychiatric_df**: 
  Originally NeuroCog from the heplots package, licensed under GPL (>= 2). The dataset name has been changed to 'neurocognitive_psychiatric_df' to indicate that this dataset is a data frame object. 

- **ability_intelligence_list**: 
  Originally ability_list from the educationR package, licensed under GPL-3. The dataset name has been changed to 'ability_intelligence_list' to indicate that this dataset is a list object. 

- **migraine_treatment_df**: 
  Originally KosteckiDillon from the carData package, licensed under GPL (>= 2). The dataset name has been changed to 'migraine_treatment_df' to indicate that this dataset is a data frame object. 

- **dopamine_schizophrenia_tbl_df**: 
  Originally Dopamine from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'dopamine_schizophrenia_tbl_df' to indicate that this dataset is a tibble object. 

- **pediatric_glioma_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/amraam/pediatric-high-grade-glioma-dataset), licensed under CC0: Public Domain. Contains clinical parameters of 57 pediatric patients with high grade glioma, including tumor size data and outcome variables.


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `NeuroDataSets`, is licensed under the GPL-3 License.
