% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_csd.R
\name{nd.csd}
\alias{nd.csd}
\title{\eqn{L_2} Distance of Continuous Spectral Densities}
\usage{
nd.csd(A, out.dist = TRUE, bandwidth = 1)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{bandwidth}{common bandwidth of positive real number.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M-1)} matrix where each row is top-\eqn{M-1} vibrational spectra.}
}
}
\description{
The method employs spectral density of eigenvalues from
Laplacian in that for each, we have corresponding
spectral density \eqn{\rho(w)} as a sum of
narrow Lorentz distributions with \code{bandwidth} parameter.
Since it involves integration of a function over the
non-compact domain, it may blow up to infinity and the code
automatically aborts the process.
}
\examples{
\donttest{
## load example data
data(graph20)

## compute distance matrix
output = nd.csd(graph20, out.dist=FALSE, bandwidth=1.0)

## visualize
opar = par(no.readonly=TRUE)
par(pty="s")
image(output$D[,20:1], main="two group case", axes=FALSE, col=gray(0:32/32))
par(opar)
}

}
\references{
\insertRef{ipsen_evolutionary_2002}{NetworkDistance}
}
