% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{diet_rel_abundance}
\alias{diet_rel_abundance}
\alias{diet_rel_abundance.data.frame}
\alias{diet_rel_abundance.matrix}
\alias{diet_rel_abundance.default}
\title{Calculate Diet Relative or Absolute Abundance}
\usage{
diet_rel_abundance(data, total.abundance = NULL, relative = TRUE, ...)

\method{diet_rel_abundance}{data.frame}(data, total.abundance = NULL, relative = TRUE, ...)

\method{diet_rel_abundance}{matrix}(data, total.abundance = NULL, relative = TRUE, ...)

\method{diet_rel_abundance}{default}(data, total.abundance = NULL, relative = TRUE, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{total.abundance}{\code{data.frame}. A data frame with sample names as row names and a single column containing the total nematode abundance for each sample.
This parameter is required when \code{relative} is set to \code{FALSE}. Default is \code{NULL}.}

\item{relative}{\code{Logical}. If \code{TRUE} (default), the function calculates relative abundance (does not require \code{total.abundance}).
If \code{FALSE}, the function calculates absolute abundance (requires \code{total.abundance}).}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame with five columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names of \code{data})}
\item{Ba}{Relative or absolute abundance of bacterial feeders}
\item{Fu}{Relative or absolute abundance of fungus feeders}
\item{Pp}{Relative or absolute abundance of plant feeders}
\item{Op}{Relative or absolute abundance of omnivores/predators}
}
\description{
TThis function calculates the relative or absolute abundance of four feeding types of nematodes in each sample.
The feeding types include bacterial feeders (Ba), fungus feeders (Fu), plant feeders (Pp), and omnivores/predators (Op).
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
abundance <- data.frame(
  abundance = c(100, 150, 120),
  row.names = c("A", "B", "C")
)
diet_rel_abundance(df, abundance, relative = FALSE)

# Example with a matrix
mat <- matrix(c(10, NA, 15, 5, 10, NA, 8, 12, 10), nrow = 3, byrow = TRUE)
colnames(mat) <- c("Cephalobus", "Caenorhabditis", "Pratylenchus")
row.names(mat) <- c("A", "B", "C")
diet_rel_abundance(mat)
}
