% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TN.R
\name{TN_plot}
\alias{TN_plot}
\title{Plot Trait Network Graph}
\usage{
TN_plot(graph, style = 1, vertex.size = 20, vertex.label.cex = 0.6)
}
\arguments{
\item{graph}{An igraph object representing the trait network.}

\item{style}{A numeric value that determines the plotting style (default is 1).}

\item{vertex.size}{Numeric value for the size of vertices in the plot (default is 20).}

\item{vertex.label.cex}{Numeric value for the scaling factor of vertex labels (default is 0.6).}
}
\value{
An object of class \code{igraph}. This function generates a visualization of the trait network graph.
When style = 1, it displays a community structure plot.
When style = 2, it displays a circular layout plot where vertex colors represent community membership,
edge thickness represents correlation strength, and edge color represents the sign of the correlation (black for positive, red for negative).
}
\description{
This function visualizes the trait network graph generated by the \code{TN} function.
}
\details{
The function uses the \code{cluster_edge_betweenness} algorithm to identify communities
in the graph and assigns community membership to vertices. It offers two
plotting styles:
\itemize{
\item Style 1: Plots the community structure.
\item Style 2: Plots the graph in a circular layout with vertex colors representing communities.
The vertex size and label size can be customized using vertex.size and vertex.label.cex parameters respectively.
}
}
\examples{
data(PFF)
PFF_traits <- PFF[, c("Height", "Leaf_area","LDMC","SLA","SRL","SeedMass","FltDate",
                      "FltDur","Leaf_Cmass","Leaf_Nmass","Leaf_CN","Leaf_Pmass",
                      "Leaf_NP","Leaf_CP","Root_Cmass","Root_Nmass","Root_CN")]
PFF_traits <- na.omit(PFF_traits)
head(PFF_traits)
Tn_result <- TN(traits_matrix = PFF_traits, rThres = 0.2, pThres = 0.05)
TN_plot(Tn_result, style = 1, vertex.size = 20, vertex.label.cex = 0.6)
TN_plot(Tn_result, style = 2, vertex.size = 20, vertex.label.cex = 0.6)

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation. Trends in Ecology & Evolution, 35(10), 908-918. https://doi.org/10.1016/j.tree.2020.06.003
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457. https://doi.org/10.1111/ele.14009
}
}
