% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{cutadapt_remove_primers}
\alias{cutadapt_remove_primers}
\title{Remove primers using \href{https://github.com/marcelm/cutadapt/}{cutadapt}}
\usage{
cutadapt_remove_primers(
  path_to_fastq,
  primer_fw = NULL,
  primer_rev = NULL,
  folder_output = "wo_primers",
  nproc = 1,
  pattern = "fastq.gz",
  pattern_R1 = "_R1",
  pattern_R2 = "_R2",
  nb_files = Inf,
  cmd_is_run = TRUE,
  return_file_path = FALSE,
  args_before_cutadapt =
    "source ~/miniconda3/etc/profile.d/conda.sh && conda activate cutadaptenv && "
)
}
\arguments{
\item{path_to_fastq}{(Required) A path to a folder with fastq files. See
\code{\link[=list_fastq_files]{list_fastq_files()}} for help.}

\item{primer_fw}{(Required, String) The forward primer DNA sequence.}

\item{primer_rev}{(String)  The reverse primer DNA sequence.}

\item{folder_output}{The path to a folder for output files}

\item{nproc}{(default 1)
Set to number of cpus/processors to use for the clustering}

\item{pattern}{a pattern to filter files (passed on to list.files function).}

\item{pattern_R1}{a pattern to filter R1 files (default "\emph{R1}")}

\item{pattern_R2}{a pattern to filter R2 files (default "\emph{R2}")}

\item{nb_files}{the number of fastq files to list (default FALSE)}

\item{cmd_is_run}{(logical, default TRUE) Do the cutadapt command is run.
If set to FALSE, the only effect of the function is to return a list of
command to manually run in a terminal.}

\item{return_file_path}{(logical, default FALSE) If true, the function
return the path of the output folder (param \code{folder_output}). Useful
in targets workflow}

\item{args_before_cutadapt}{(String) A one line bash command to run before
to run cutadapt. For examples, "source ~/miniconda3/etc/profile.d/conda.sh && conda activate cutadaptenv &&" allow to bypass the conda init which asks to restart the shell}
}
\value{
a list of command or if \code{return_file_path} is TRUE, the path to
the output folder
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


You need to install \href{https://cutadapt.readthedocs.io/}{Cutadapt}.
See also https://github.com/VascoElbrecht/JAMP/blob/master/JAMP/R/Cutadapt.R for another call to cutadapt
from R
}
\details{
This function is mainly a wrapper of the work of others.
Please cite cutadapt (\doi{doi:10.14806/ej.17.1.200}).
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
cutadapt_remove_primers(system.file("extdata", package = "MiscMetabar"),
  "TTC",
  "GAA",
  folder_output = tempdir()
)

cutadapt_remove_primers(
  system.file("extdata",
    package = "dada2"
  ),
  pattern_R1 = "F.fastq.gz",
  pattern_R2 = "R.fastq.gz",
  primer_fw = "TTC",
  primer_rev = "GAA",
  folder_output = tempdir()
)

cutadapt_remove_primers(
  system.file("extdata",
    package = "dada2"
  ),
  pattern_R1 = "F.fastq.gz",
  primer_fw = "TTC",
  folder_output = tempdir(),
  cmd_is_run = FALSE
)

unlink(tempdir(), recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
